/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import com.bowman.util.TelnetDaemonConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Vt100TerminalEmulator {
    private static final int[] HOMEPOS = new int[]{0, 0};
    private static final int IOERROR = -1;
    private static final int UP = 1001;
    private static final int DOWN = 1002;
    private static final int RIGHT = 1003;
    private static final int LEFT = 1004;
    private static final int HOME = 1005;
    private static final int STORECURSOR = 1051;
    private static final int RESTORECURSOR = 1052;
    private static final int EEOL = 1100;
    private static final int EBOL = 1101;
    private static final int EEL = 1103;
    private static final int EEOS = 1104;
    private static final int EBOS = 1105;
    private static final int EES = 1106;
    private static final int ESCAPE = 1200;
    private static final int BYTEMISSING = 1201;
    private static final int UNRECOGNIZED = 1202;
    private static final int ENTER = 1300;
    private static final int TABULATOR = 1301;
    private static final int DELETE = 1302;
    private static final int BACKSPACE = 1303;
    private static final int COLORINIT = 1304;
    private static final int HANDLED = 1305;
    private static final int LOGOUTREQUEST = 1306;
    private static final int LineUpdate = 475;
    private static final int CharacterUpdate = 476;
    private static final int ScreenpartUpdate = 477;
    private static final int EditBuffer = 575;
    private static final int LineEditBuffer = 576;
    private static final int BEL = 7;
    private static final int BS = 8;
    private static final int DEL = 127;
    private static final int CR = 13;
    private static final int LF = 10;
    public static final int FCOLOR = 10001;
    public static final int BCOLOR = 10002;
    public static final int STYLE = 10003;
    public static final int RESET = 10004;
    public static final int BOLD = 1;
    public static final int BOLD_OFF = 22;
    public static final int ITALIC = 3;
    public static final int ITALIC_OFF = 23;
    public static final int BLINK = 5;
    public static final int BLINK_OFF = 25;
    public static final int UNDERLINED = 4;
    public static final int UNDERLINED_OFF = 24;
    private static final byte EOT = 4;
    private static final byte HT = 9;
    private static final byte FF = 12;
    private static final byte SGR = 1;
    private static final byte CAN = 24;
    private static final byte ESC = 27;
    private static final byte LSB = 91;
    private static final byte SEMICOLON = 59;
    private static final byte A = 65;
    private static final byte B = 66;
    private static final byte C = 67;
    private static final byte D = 68;
    private static final byte E = 69;
    private static final byte H = 72;
    private static final byte f = 102;
    private static final byte r = 114;
    private static final byte LE = 75;
    private static final byte SE = 74;
    private static final String CRLF = "\r\n";
    private TelnetDaemonConnection telnetConn;
    private Colorizer colorizer;
    private boolean acousticSignalling = true;
    private static final String INTERNAL_MARKER = "\u0001";
    private static final int MARKER_CODE = 1;
    private static final String BLACK = "S";
    private static final String RED = "R";
    private static final String GREEN = "G";
    private static final String YELLOW = "Y";
    private static final String BLUE = "B";
    private static final String MAGENTA = "M";
    private static final String CYAN = "C";
    private static final String WHITE = "W";
    private static final String BOLDSTR = "f";
    private static final String BOLDSTR_OFF = "d";
    private static final String ITALICSTR = "i";
    private static final String ITALICSTR_OFF = "j";
    private static final String UNDERLINEDSTR = "u";
    private static final String UNDERLINEDSTR_OFF = "v";
    private static final String BLINKSTR = "e";
    private static final String BLINKSTR_OFF = "n";
    private static final String RESET_ALL = "a";

    public static void main(String[] args) throws IOException {
        ServerSocket s = new ServerSocket(2324);
        Vt100TerminalEmulator emu = new Vt100TerminalEmulator(s.accept());
        emu.setBold(true);
        emu.writeLine("Dummy shell test welcome message!");
        emu.moveDown(1);
        emu.setBold(false);
        emu.write("Login: ");
        int in = 0;
        StringBuffer inputBuffer = new StringBuffer();
        while (in != 13) {
            in = emu.read();
            System.out.println(in);
            if (in != 13) {
                inputBuffer.append((char)in);
            }
            emu.write((char)in);
        }
        System.out.println("username: " + inputBuffer);
        in = 0;
        inputBuffer = new StringBuffer();
        emu.write("Password: ");
        while (in != 13) {
            in = emu.read();
            System.out.println(in);
            if (in == 13) continue;
            inputBuffer.append((char)in);
            emu.write('.');
        }
        System.out.println("password: " + inputBuffer);
    }

    public Vt100TerminalEmulator(Socket con) {
        this.telnetConn = new TelnetDaemonConnection(con);
        this.colorizer = new Colorizer();
        this.initTerminal();
        this.read();
    }

    public int read() {
        int i = this.telnetConn.read();
        if ((i = this.translateControlCharacter(i)) == 1306) {
            i = 1305;
        } else if (i > 256 && i == 1200) {
            i = this.handleEscapeSequence(i);
        }
        return i;
    }

    public void write(char ch) {
        this.telnetConn.write(ch);
        this.flush();
    }

    public void write(String str) {
        this.telnetConn.write(this.format(str));
        this.flush();
    }

    public void writeLine(String str) {
        this.write(str + CRLF);
    }

    public void eraseToEndOfLine() {
        this.doErase(1100);
    }

    public void eraseToBeginOfLine() {
        this.doErase(1101);
    }

    public void eraseLine() {
        this.doErase(1103);
    }

    public void eraseToEndOfScreen() {
        this.doErase(1104);
    }

    public void eraseToBeginOfScreen() {
        this.doErase(1105);
    }

    public void eraseScreen() {
        this.doErase(1106);
    }

    private void doErase(int funcConst) {
        this.telnetConn.write(this.getEraseSequence(funcConst));
        this.flush();
    }

    public void moveCursor(int direction, int times) {
        this.telnetConn.write(this.getCursorMoveSequence(direction, times));
        this.flush();
    }

    public void moveLeft(int times) {
        this.moveCursor(1004, times);
    }

    public void moveRight(int times) {
        this.moveCursor(1003, times);
    }

    public void moveUp(int times) {
        this.moveCursor(1001, times);
    }

    public void moveDown(int times) {
        this.moveCursor(1002, times);
    }

    public void setCursor(int row, int col) {
        int[] pos = new int[]{row, col};
        this.telnetConn.write(this.getCursorPositioningSequence(pos));
        this.flush();
    }

    public void homeCursor() {
        this.telnetConn.write(this.getCursorPositioningSequence(HOMEPOS));
        this.flush();
    }

    public void storeCursor() {
        this.telnetConn.write(this.getSpecialSequence(1051));
    }

    public void restoreCursor() {
        this.telnetConn.write(this.getSpecialSequence(1052));
    }

    public void setSignalling(boolean bool) {
        this.acousticSignalling = bool;
    }

    public boolean isSignalling() {
        return this.acousticSignalling;
    }

    public void bell() {
        if (this.acousticSignalling) {
            this.telnetConn.write(7);
        }
        this.flush();
    }

    public boolean defineScrollRegion(int topmargin, int bottommargin) {
        this.telnetConn.write(this.getScrollMarginsSequence(topmargin, bottommargin));
        this.flush();
        return true;
    }

    public void setForegroundColor(int color) {
        this.telnetConn.write(this.getGRSequence(10001, color));
        this.flush();
    }

    public void setBackgroundColor(int color) {
        this.telnetConn.write(this.getGRSequence(10002, color + 10));
        this.flush();
    }

    public void setBold(boolean b) {
        if (b) {
            this.telnetConn.write(this.getGRSequence(10003, 1));
        } else {
            this.telnetConn.write(this.getGRSequence(10003, 22));
        }
        this.flush();
    }

    public void setUnderlined(boolean b) {
        if (b) {
            this.telnetConn.write(this.getGRSequence(10003, 4));
        } else {
            this.telnetConn.write(this.getGRSequence(10003, 24));
        }
        this.flush();
    }

    public void setItalic(boolean b) {
        if (b) {
            this.telnetConn.write(this.getGRSequence(10003, 3));
        } else {
            this.telnetConn.write(this.getGRSequence(10003, 23));
        }
        this.flush();
    }

    public void setBlink(boolean b) {
        if (b) {
            this.telnetConn.write(this.getGRSequence(10003, 5));
        } else {
            this.telnetConn.write(this.getGRSequence(10003, 25));
        }
        this.flush();
    }

    public void resetAttributes() {
        this.telnetConn.write(this.getGRSequence(10004, 0));
    }

    private int handleEscapeSequence(int i) {
        if (i == 1200) {
            int[] bytebuf = new int[this.getAtomicSequenceLength()];
            for (int m = 0; m < bytebuf.length; ++m) {
                bytebuf[m] = this.telnetConn.read();
            }
            return this.translateEscapeSequence(bytebuf);
        }
        if (i == 1201) {
            // empty if block
        }
        return 1305;
    }

    public void flush() {
        this.telnetConn.flush();
    }

    public void close() {
        this.telnetConn.closeOutput();
    }

    private void initTerminal() {
        this.telnetConn.write(this.getInitSequence());
        this.flush();
    }

    private int translateControlCharacter(int c) {
        switch (c) {
            case 127: {
                return 1302;
            }
            case 8: {
                return 1303;
            }
            case 9: {
                return 1301;
            }
            case 27: {
                return 1200;
            }
            case 1: {
                return 1304;
            }
            case 4: {
                return 1306;
            }
        }
        return c;
    }

    private int translateEscapeSequence(int[] buffer) {
        try {
            if (buffer[0] == 91) {
                switch (buffer[1]) {
                    case 65: {
                        return 1001;
                    }
                    case 66: {
                        return 1002;
                    }
                    case 67: {
                        return 1003;
                    }
                    case 68: {
                        return 1004;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1201;
        }
        return 1202;
    }

    private byte[] getCursorMoveSequence(int direction, int times) {
        byte[] sequence = null;
        sequence = times == 1 ? new byte[3] : new byte[times * 3];
        for (int g = 0; g < times * 3; ++g) {
            sequence[g] = 27;
            sequence[g + 1] = 91;
            switch (direction) {
                case 1001: {
                    sequence[g + 2] = 65;
                    break;
                }
                case 1002: {
                    sequence[g + 2] = 66;
                    break;
                }
                case 1003: {
                    sequence[g + 2] = 67;
                    break;
                }
                case 1004: {
                    sequence[g + 2] = 68;
                    break;
                }
            }
            g += 2;
        }
        return sequence;
    }

    private byte[] getCursorPositioningSequence(int[] pos) {
        byte[] sequence = null;
        if (pos == HOMEPOS) {
            sequence = new byte[]{27, 91, 72};
        } else {
            byte[] rowdigits = this.translateIntToDigitCodes(pos[0]);
            byte[] columndigits = this.translateIntToDigitCodes(pos[1]);
            int offset = 0;
            sequence = new byte[4 + rowdigits.length + columndigits.length];
            sequence[0] = 27;
            sequence[1] = 91;
            System.arraycopy(rowdigits, 0, sequence, 2, rowdigits.length);
            offset = 2 + rowdigits.length;
            sequence[offset] = 59;
            System.arraycopy(columndigits, 0, sequence, ++offset, columndigits.length);
            sequence[offset += columndigits.length] = 72;
        }
        return sequence;
    }

    private byte[] getEraseSequence(int eraseFunc) {
        byte[] sequence = null;
        switch (eraseFunc) {
            case 1100: {
                sequence = new byte[]{27, 91, 75};
                break;
            }
            case 1101: {
                sequence = new byte[]{27, 91, 49, 75};
                break;
            }
            case 1103: {
                sequence = new byte[]{27, 91, 50, 75};
                break;
            }
            case 1104: {
                sequence = new byte[]{27, 91, 74};
                break;
            }
            case 1105: {
                sequence = new byte[]{27, 91, 49, 74};
                break;
            }
            case 1106: {
                sequence = new byte[]{27, 91, 50, 74};
                break;
            }
        }
        return sequence;
    }

    private byte[] getSpecialSequence(int function) {
        byte[] sequence = null;
        switch (function) {
            case 1051: {
                sequence = new byte[]{27, 55};
                break;
            }
            case 1052: {
                sequence = new byte[]{27, 56};
            }
        }
        return sequence;
    }

    public byte[] getGRSequence(int type, int param) {
        byte[] sequence = new byte[]{};
        int offset = 0;
        switch (type) {
            case 10001: 
            case 10002: {
                byte[] color = this.translateIntToDigitCodes(param);
                sequence = new byte[3 + color.length];
                sequence[0] = 27;
                sequence[1] = 91;
                System.arraycopy(color, 0, sequence, 2, color.length);
                offset = 2 + color.length;
                sequence[offset] = 109;
                break;
            }
            case 10003: {
                byte[] style = this.translateIntToDigitCodes(param);
                sequence = new byte[3 + style.length];
                sequence[0] = 27;
                sequence[1] = 91;
                System.arraycopy(style, 0, sequence, 2, style.length);
                offset = 2 + style.length;
                sequence[offset] = 109;
                break;
            }
            case 10004: {
                sequence = new byte[]{27, 91, 52, 56, 109};
            }
        }
        return sequence;
    }

    private byte[] getScrollMarginsSequence(int topmargin, int bottommargin) {
        byte[] sequence = new byte[]{};
        byte[] topdigits = this.translateIntToDigitCodes(topmargin);
        byte[] bottomdigits = this.translateIntToDigitCodes(bottommargin);
        int offset = 0;
        sequence = new byte[4 + topdigits.length + bottomdigits.length];
        sequence[0] = 27;
        sequence[1] = 91;
        System.arraycopy(topdigits, 0, sequence, 2, topdigits.length);
        offset = 2 + topdigits.length;
        sequence[offset] = 59;
        System.arraycopy(bottomdigits, 0, sequence, ++offset, bottomdigits.length);
        sequence[offset += bottomdigits.length] = 114;
        return sequence;
    }

    public String format(String str) {
        return this.colorizer.colorize(str, true);
    }

    private byte[] getInitSequence() {
        return new byte[0];
    }

    private int getAtomicSequenceLength() {
        return 2;
    }

    private byte[] translateIntToDigitCodes(int in) {
        return Integer.toString(in).getBytes();
    }

    private static String colorizeText(String str, String color) {
        return INTERNAL_MARKER + color + str + INTERNAL_MARKER + RESET_ALL;
    }

    private static String colorizeBackground(String str, String color) {
        return INTERNAL_MARKER + color.toLowerCase() + str + INTERNAL_MARKER + RESET_ALL;
    }

    private static String colorizeText(String str, String fgc, String bgc) {
        return INTERNAL_MARKER + fgc + INTERNAL_MARKER + bgc.toLowerCase() + str + INTERNAL_MARKER + RESET_ALL;
    }

    private static String boldcolorizeText(String str, String color) {
        return "\u0001f\u0001" + color + str + INTERNAL_MARKER + RESET_ALL;
    }

    private static String boldcolorizeText(String str, String fgc, String bgc) {
        return "\u0001f\u0001" + fgc + INTERNAL_MARKER + bgc.toLowerCase() + str + INTERNAL_MARKER + RESET_ALL;
    }

    private static String boldText(String str) {
        return "\u0001f" + str + INTERNAL_MARKER + BOLDSTR_OFF;
    }

    private static String italicText(String str) {
        return "\u0001i" + str + INTERNAL_MARKER + ITALICSTR_OFF;
    }

    private static String underlinedText(String str) {
        return "\u0001u" + str + INTERNAL_MARKER + UNDERLINEDSTR_OFF;
    }

    private static String blinkingText(String str) {
        return "\u0001e" + str + INTERNAL_MARKER + BLINKSTR_OFF;
    }

    private static long getVisibleLength(String str) {
        int counter = 0;
        int parsecursor = 0;
        int foundcursor = 0;
        boolean done = false;
        while (!done) {
            foundcursor = str.indexOf(1, parsecursor);
            if (foundcursor != -1) {
                ++counter;
                parsecursor = foundcursor + 1;
                continue;
            }
            done = true;
        }
        return str.length() - counter * 2;
    }

    private class Colorizer {
        private int[] colortranslation = new int[128];
        private int leng;
        private final int S = 30;
        private final int s = 40;
        private final int R = 31;
        private final int r = 41;
        private final int G = 32;
        private final int g = 42;
        private final int Y = 33;
        private final int y = 43;
        private final int B = 34;
        private final int b = 44;
        private final int M = 35;
        private final int m = 45;
        private final int C = 36;
        private final int c = 46;
        private final int W = 37;
        private final int w = 47;
        private final int f = 1;
        private final int d = 22;
        private final int i = 3;
        private final int j = 23;
        private final int u = 4;
        private final int v = 24;
        private final int e = 5;
        private final int n = 25;
        private final int h = 8;
        private final int a = 0;

        Colorizer() {
            this.colortranslation[83] = 30;
            this.colortranslation[82] = 31;
            this.colortranslation[71] = 32;
            this.colortranslation[89] = 33;
            this.colortranslation[66] = 34;
            this.colortranslation[77] = 35;
            this.colortranslation[67] = 36;
            this.colortranslation[87] = 37;
            this.colortranslation[115] = 40;
            this.colortranslation[114] = 41;
            this.colortranslation[103] = 42;
            this.colortranslation[121] = 43;
            this.colortranslation[98] = 44;
            this.colortranslation[109] = 45;
            this.colortranslation[99] = 46;
            this.colortranslation[119] = 47;
            this.colortranslation[102] = 1;
            this.colortranslation[100] = 22;
            this.colortranslation[105] = 3;
            this.colortranslation[106] = 23;
            this.colortranslation[117] = 4;
            this.colortranslation[118] = 24;
            this.colortranslation[101] = 5;
            this.colortranslation[110] = 25;
            this.colortranslation[104] = 8;
            this.colortranslation[97] = 0;
        }

        public String colorize(String str, boolean support) {
            StringBuffer out = new StringBuffer(str.length() + 20);
            int parsecursor = 0;
            int foundcursor = 0;
            boolean done = false;
            while (!done) {
                foundcursor = str.indexOf(1, parsecursor);
                if (foundcursor != -1) {
                    out.append(str.substring(parsecursor, foundcursor));
                    if (support) {
                        out.append(this.addEscapeSequence(str.substring(foundcursor + 1, foundcursor + 2)));
                    }
                    parsecursor = foundcursor + 2;
                    continue;
                }
                out.append(str.substring(parsecursor, str.length()));
                done = true;
            }
            if (support) {
                out.append(this.addEscapeSequence(Vt100TerminalEmulator.RESET_ALL));
            }
            return out.toString();
        }

        private String addEscapeSequence(String attribute) {
            StringBuffer tmpbuf = new StringBuffer(10);
            byte[] tmpbytes = attribute.getBytes();
            byte key = tmpbytes[0];
            tmpbuf.append('\u001b');
            tmpbuf.append('[');
            tmpbuf.append(new Integer(this.colortranslation[key]).toString());
            tmpbuf.append('m');
            return tmpbuf.toString();
        }
    }
}

