/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import com.bowman.util.FileChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileWatchdog
implements Runnable {
    private static final long DEFAULT_INTERVAL = 30000L;
    private static Set allWatchdogs = new HashSet();
    private static Thread watcherThread;
    private Thread taskThread;
    private List changedFiles;
    private Map observedFiles = new HashMap();
    private FileChangeListener fileChangeListener;
    private long interval = 30000L;

    public FileWatchdog() {
        this.changedFiles = new ArrayList();
        allWatchdogs.add(this);
    }

    public FileWatchdog(String fileName, long interval) {
        this();
        this.interval = interval;
        this.addFile(fileName);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void addFile(String fileName) {
        if (!this.observedFiles.containsKey(fileName)) {
            ObservedFile observedFile = new ObservedFile();
            observedFile.file = new File(fileName);
            observedFile.lastModified = observedFile.file.lastModified();
            this.observedFiles.put(fileName, observedFile);
        }
    }

    public void start() {
        if (watcherThread == null) {
            watcherThread = new Thread((Runnable)this, "FileWatchdogThread");
            watcherThread.setDaemon(true);
            watcherThread.start();
        }
    }

    public void removeFile(String fileName) {
        this.observedFiles.remove(fileName);
    }

    public void removeAllFiles() {
        this.observedFiles.clear();
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.fileChangeListener = fileChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Thread.currentThread() == watcherThread) {
            while (watcherThread != null) {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    return;
                }
                Iterator iter = new ArrayList(allWatchdogs).iterator();
                while (iter.hasNext()) {
                    ((FileWatchdog)iter.next()).checkNow();
                }
            }
        } else if (Thread.currentThread() == this.taskThread) {
            FileWatchdog fileWatchdog = this;
            synchronized (fileWatchdog) {
                if (this.fileChangeListener != null) {
                    Iterator iter = this.changedFiles.iterator();
                    while (iter.hasNext()) {
                        try {
                            this.fileChangeListener.fileChanged((String)iter.next());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            break;
                        }
                    }
                }
                this.changedFiles.clear();
                this.taskThread = null;
            }
        }
    }

    protected synchronized void checkNow() {
        if (this.taskThread != null) {
            return;
        }
        this.changedFiles.clear();
        Iterator iter = this.observedFiles.keySet().iterator();
        while (iter.hasNext()) {
            ObservedFile observedFile = (ObservedFile)this.observedFiles.get((String)iter.next());
            String fileName = observedFile.file.getPath();
            if (observedFile.lastModified == observedFile.file.lastModified() || this.fileChangeListener == null) continue;
            observedFile.lastModified = observedFile.file.lastModified();
            this.changedFiles.add(fileName);
        }
        if (!this.changedFiles.isEmpty() && this.taskThread == null) {
            this.taskThread = new Thread((Runnable)this, "FileWatchdogThread" + this.changedFiles);
            this.taskThread.start();
        }
    }

    public void interrupt() {
        if (this.taskThread != null) {
            this.taskThread.interrupt();
        }
        this.taskThread = null;
    }

    public static void abortAll() {
        Thread t = watcherThread;
        watcherThread = null;
        t.interrupt();
        Iterator iter = allWatchdogs.iterator();
        while (iter.hasNext()) {
            ((FileWatchdog)iter.next()).interrupt();
        }
    }

    private static class ObservedFile {
        long lastModified;
        File file;

        private ObservedFile() {
        }
    }
}

