/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.rmi.UserStatus;
import com.bowman.cardserv.session.SeenEntry;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.StatusCommand;
import com.bowman.cardserv.web.XmlHelper;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class GeoipPlugin
implements ProxyPlugin {
    private static final long MONTH = 2678400L;
    private String db;
    private LookupService service;
    private RemoteHandler proxy;
    private ProxyLogger logger;
    private StatusCommand usersCmd;
    private Map lastRequest = new HashMap();
    private String gmapsKey;
    private String dbInfo;
    private String startLat;
    private String startLong;
    private String startZoom;

    public GeoipPlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.db = xml.getFileValue("geoipcity-path", false);
        this.gmapsKey = xml.getStringValue("googlemaps-key", "");
        this.startLat = xml.getStringValue("start-lat", "62.35");
        this.startLong = xml.getStringValue("start-long", "18.066667");
        this.startZoom = xml.getStringValue("start-zoom", "5");
        try {
            this.service = new LookupService(this.db, 0);
        }
        catch (IOException e) {
            throw new ConfigException(xml.getFullName(), "Unable to load geoipcity database: " + e);
        }
    }

    public void start(CardServProxy proxy) {
        this.proxy = proxy.getRemoteHandler();
        try {
            this.usersCmd = new StatusCommand("proxy-users", "Show user(s)", "List of current user connections with geoip info.", false);
            this.usersCmd.register((Object)this, true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Date dbDate = this.service.getDatabaseInfo().getDate();
        this.dbInfo = new File(this.db).getName() + " built on " + new SimpleDateFormat("yyyy-MM-dd").format(dbDate);
        this.logger.info("Using database: " + this.dbInfo);
        long dbAge = (System.currentTimeMillis() - dbDate.getTime()) / 1000L;
        if (dbAge > 2678400L) {
            this.logger.warning("Database is older than one month: " + XmlHelper.formatDuration((long)dbAge));
        }
    }

    public void stop() {
        if (this.usersCmd != null) {
            this.usersCmd.unregister();
            this.usersCmd = null;
        }
        if (this.service != null) {
            this.service.close();
            this.service = null;
        }
    }

    public void runStatusCmdProxyUsers(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String[] profiles = (String[])params.get("profiles");
        UserStatus[] users = null;
        String userName = (String)params.get("name");
        boolean activeOnly = "true".equalsIgnoreCase((String)params.get("hide-inactive"));
        if (!this.proxy.isAdmin(user)) {
            userName = user;
        }
        if (userName != null) {
            UserStatus temp = this.proxy.getUserStatus(userName, activeOnly);
            if (temp != null) {
                users = new UserStatus[]{temp};
            }
        } else {
            users = this.proxy.getUsersStatus(profiles, activeOnly);
        }
        if (users != null) {
            this.lastRequest.clear();
            for (int i = 0; i < users.length; ++i) {
                this.locateUser(users[i]);
                this.addToLocation(users[i]);
            }
        }
        SeenEntry[] seen = this.proxy.getSeenUsers(null, userName, true);
        XmlHelper.xmlFormatUsers((UserStatus[])users, (int)seen.length, (XmlStringBuffer)xb);
    }

    private void addToLocation(UserStatus user) {
        String key = user.getProperty("geoip-lat") + "," + user.getProperty("geoip-long");
        ArrayList<UserStatus> users = (ArrayList<UserStatus>)this.lastRequest.get(key);
        if (users == null) {
            users = new ArrayList<UserStatus>();
            this.lastRequest.put(key, users);
        }
        users.add(user);
    }

    private void locateUser(UserStatus user) {
        Location loc;
        HashSet<String> hosts = new HashSet<String>(Arrays.asList(user.getRemoteHosts()));
        Iterator iter = hosts.iterator();
        if (iter.hasNext() && (loc = this.service.getLocation((String)iter.next())) != null) {
            user.setProperty("geoip-lat", String.valueOf(loc.latitude));
            user.setProperty("geoip-long", String.valueOf(loc.longitude));
            user.setProperty("geoip-city", loc.city == null ? "Unknown" : String.valueOf(loc.city));
        }
    }

    public String getName() {
        return "GeoipPlugin";
    }

    public String getDescription() {
        return "Adds geoip information to user ip addresses, displayed using google maps.";
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty("database", this.dbInfo);
        return p;
    }

    public CamdNetMessage doFilter(ProxySession proxySession, CamdNetMessage msg) {
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            DataInputStream dis = new DataInputStream(GeoipPlugin.class.getResourceAsStream("/web/" + path));
            byte[] buf = new byte[dis.available()];
            dis.readFully(buf);
            if ("googlemap.html".equals(path)) {
                String text = MessageFormat.format(new String(buf, "UTF-8"), this.gmapsKey, this.generateJs());
                buf = text.getBytes("UTF-8");
            } else if ("load.js".equals(path)) {
                StringBuffer sb = new StringBuffer("var dbInfo = ");
                sb.append("'").append(this.dbInfo).append("'\n");
                sb.append(new String(buf, "UTF-8"));
                buf = sb.toString().getBytes("UTF-8");
            }
            return buf;
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }

    private String generateJs() {
        StringBuffer sb = new StringBuffer();
        sb.append("function load() {\n");
        sb.append("if(GBrowserIsCompatible()) {\n");
        sb.append("var map = new GMap2(document.getElementById('map'));\n");
        sb.append("map.addControl(new GLargeMapControl());\n");
        sb.append("map.addControl(new GMapTypeControl());\n");
        sb.append("map.setCenter(new GLatLng(").append(this.startLat).append(", ").append(this.startLong).append("), ");
        sb.append(this.startZoom).append(");\n");
        int i = 0;
        Iterator iter = this.lastRequest.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List users = (List)this.lastRequest.get(key);
            UserStatus user = (UserStatus)users.iterator().next();
            sb.append("marker").append(++i).append(" = new GMarker(new GLatLng(").append(user.getProperty("geoip-lat")).append(", ");
            sb.append(user.getProperty("geoip-long")).append("));\n");
            sb.append("map.addOverlay(marker").append(i).append(");\n");
            sb.append("GEvent.addListener(marker").append(i).append(", 'click', function() {\n");
            sb.append("marker").append(i).append(".openInfoWindowHtml(\"");
            sb.append("<div style='font-family:Arial;font-size:8pt'>");
            Iterator u = users.iterator();
            while (u.hasNext()) {
                user = (UserStatus)u.next();
                sb.append("User: <strong>").append(user.getUserName());
                sb.append("</strong> IP: <strong>");
                sb.append(CustomFormatter.formatAddress((String)user.getRemoteHosts()[0]));
                sb.append("</strong><br/>");
            }
            sb.append("<br/>City: <strong>").append(user.getProperty("geoip-city")).append("</strong></div>\");");
            sb.append("});\n");
        }
        sb.append("}\n}\n");
        return sb.toString();
    }
}

