/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.MessagingPlugin;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.rmi.RemoteEvent;
import com.bowman.cardserv.rmi.RemoteListener;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.FileFetcher;
import com.bowman.util.CronTimer;
import com.bowman.util.CronTimerListener;
import com.bowman.xml.XMLConfig;
import com.bowman.xml.XMLConfigException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TriggerMessenger
implements RemoteListener,
XmlConfigurable,
CronTimerListener {
    private static final String[] LEGEND = new String[]{"User login", "Channel changed", "Successfully connected", "Disconnected", "Connection attempt failed", "Warning (timeout)", "Lost service", "", "Invalid card data", "", "Startup"};
    private static final SimpleDateFormat fmt = new SimpleDateFormat("yyMMdd HH:mm:ss");
    private MessagingPlugin parent;
    private Set excludeUsers;
    private Set excludeProfiles;
    private Set triggers = new HashSet();
    private Set externalTriggers = new HashSet();
    private Map dynamicTriggers = new HashMap();
    private Set connecting = new HashSet();
    private Set invalid = new HashSet();
    private URL triggerFileUri;
    private String triggerFile;
    private String triggerFileKey;
    private int triggerFileInterval;
    private long triggerFileLastModified;
    private long triggerFileLastCheck;

    public TriggerMessenger(MessagingPlugin parent) {
        this.parent = parent;
    }

    public void configUpdated(ProxyXmlConfig autoCfg) throws ConfigException {
        String eu = autoCfg.getStringValue("exclude-users", "");
        this.excludeUsers = !"".equals(eu) ? new HashSet<String>(Arrays.asList(eu.split(" "))) : Collections.EMPTY_SET;
        String ep = autoCfg.getStringValue("exclude-profiles", "");
        this.excludeProfiles = !"".equals(ep) ? new HashSet<String>(Arrays.asList(ep.split(" "))) : Collections.EMPTY_SET;
        Iterator iter = autoCfg.getMultipleSubConfigs("msg-trigger");
        while (iter.hasNext()) {
            this.addMsgTrigger((ProxyXmlConfig)iter.next(), this.triggers);
        }
        ProxyXmlConfig extCfg = null;
        try {
            extCfg = autoCfg.getSubConfig("external-msg-triggers");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (extCfg != null) {
            this.updateExternalTriggers(extCfg);
        } else {
            this.triggerFileUri = null;
            this.triggerFileInterval = 0;
        }
    }

    private void updateExternalTriggers(ProxyXmlConfig xml) throws ConfigException {
        boolean enabled = true;
        try {
            enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled"));
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (enabled) {
            String url = xml.getStringValue("trigger-file-url");
            try {
                this.triggerFileUri = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new ConfigException(xml.getFullName(), "trigger-file-url", "Malformed URL: " + e.getMessage());
            }
            try {
                this.triggerFileKey = xml.getStringValue("trigger-file-key");
            }
            catch (ConfigException e) {
                this.triggerFileKey = null;
            }
            this.triggerFileInterval = xml.getIntValue("update-interval") * 60 * 1000;
            this.fetchTriggerFile();
        } else {
            this.externalTriggers.clear();
            this.triggerFileUri = null;
            this.triggerFileInterval = 0;
        }
    }

    private void addMsgTrigger(ProxyXmlConfig xml, Set triggers) throws ConfigException {
        MsgTrigger trigger = new MsgTrigger(xml.getStringValue("match-flags", ""), xml.getStringValue("match-profiles", ""), xml.getStringValue("match-usernames", ""), xml.getStringValue("match-sids", ""), xml.getStringValue("admin-only", ""), xml.getStringValue("match-warnings", ""), xml.getStringValue("cws-owner-only", ""), xml.getStringValue("match-events", ""));
        ProxyXmlConfig msgXml = xml.getSubConfig("msg");
        trigger.message = new TriggerMsg("true".equals(msgXml.getStringValue("wait-for-zap", "false")), "true".equals(msgXml.getStringValue("store", "false")), msgXml.getStringValue("format"), msgXml.getStringValue("target", "@trigger"));
        triggers.add(trigger);
    }

    protected void addDynamicServiceTrigger(String name, TvService ts, String message) throws ConfigException {
        HashSet<MsgTrigger> dt = (HashSet<MsgTrigger>)this.dynamicTriggers.get(name);
        if (dt == null) {
            dt = new HashSet<MsgTrigger>();
        }
        MsgTrigger tr = new MsgTrigger("Z", ts.getProfileName(), "", Integer.toHexString(ts.getId()), "", "", "", "");
        tr.message = new TriggerMsg(false, false, message, "@trigger");
        dt.add(tr);
        this.dynamicTriggers.put(name, dt);
    }

    protected void clearDynamicServiceTrigger(String name) {
        this.dynamicTriggers.remove(name);
    }

    private boolean filterRepeats(RemoteEvent event) {
        switch (event.getType()) {
            case 2: {
                this.connecting.remove(event.getLabel());
                this.invalid.remove(event.getLabel());
                return true;
            }
            case 4: {
                if (this.connecting.contains(event.getLabel())) break;
                this.connecting.add(event.getLabel());
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return true;
            }
            case 8: {
                if (this.invalid.contains(event.getLabel())) break;
                this.invalid.add(event.getLabel());
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void eventRaised(RemoteEvent event) throws RemoteException {
        String text;
        String name;
        Collection mtr;
        boolean admin = false;
        boolean cwsOwner = false;
        String triggerUser = null;
        String service = "";
        if (!this.filterRepeats(event)) {
            return;
        }
        if (this.excludeProfiles.contains(event.getProfile())) {
            return;
        }
        if (event.getType() == 7) {
            String userName = event.getMessage();
            if (this.excludeUsers.contains(userName)) {
                return;
            }
            boolean warning = "true".equalsIgnoreCase(event.getProperty("warning"));
            String sid = event.getProperty("sid");
            admin = this.parent.proxy.isAdmin(userName);
            mtr = this.findTrTriggers(userName, event.getProfile(), event.getProperty("flags"), warning, admin, Integer.parseInt(sid, 16));
            if (mtr.isEmpty()) return;
            triggerUser = name = event.getMessage();
            service = event.getProperty("service");
            text = name + " " + event.getLabel() + " - " + service + " - " + event.getProperty("time") + " ms - '" + event.getProperty("flags") + "'";
        } else {
            mtr = this.findEvTriggers(event.getProfile(), event.getType());
            if (mtr.isEmpty()) return;
            name = event.getLabel();
            if (event.getType() > 1 && event.getType() < 10) {
                triggerUser = name.substring(name.indexOf(91) + 1);
                triggerUser = triggerUser.substring(0, triggerUser.indexOf(58));
                cwsOwner = true;
                admin = this.parent.proxy.isAdmin(triggerUser);
            }
            text = name + ":" + LEGEND[event.getType()];
            if (!name.equals(event.getMessage())) {
                text = text + " - " + event.getMessage();
            }
        }
        String time = fmt.format(new Date(event.getTimeStamp()));
        String preFormat = time + " " + text;
        Object[] strings = new Object[]{preFormat, name, event.getProfile(), service, time, text};
        String target = null;
        Iterator iter = mtr.iterator();
        while (iter.hasNext()) {
            MsgTrigger trigger = (MsgTrigger)iter.next();
            if ("@trigger".equals(trigger.message.target)) {
                if (cwsOwner) {
                    if (trigger.matchCwsOwner != null && trigger.matchCwsOwner.booleanValue()) {
                        target = triggerUser;
                    }
                } else {
                    target = triggerUser;
                }
            } else {
                target = trigger.message.target;
            }
            if (trigger.matchAdmin != null && trigger.matchAdmin.booleanValue() && !admin || "@trigger".equals(target) || target == null || this.excludeUsers.contains(target)) continue;
            this.parent.triggeredMessage(this, target, MessageFormat.format(trigger.message.msgFormat, strings));
        }
    }

    private Collection findTrTriggers(String userName, String profile, String flags, boolean warning, boolean admin, int sid) throws RemoteException {
        MsgTrigger trigger;
        HashSet<MsgTrigger> result = new HashSet<MsgTrigger>();
        Iterator iter = this.triggers.iterator();
        while (iter.hasNext()) {
            trigger = (MsgTrigger)iter.next();
            if (!trigger.matchesTransaction(userName, profile, flags, warning, admin, sid)) continue;
            result.add(trigger);
        }
        iter = this.externalTriggers.iterator();
        while (iter.hasNext()) {
            trigger = (MsgTrigger)iter.next();
            if (!trigger.matchesTransaction(userName, profile, flags, warning, admin, sid)) continue;
            result.add(trigger);
        }
        Iterator iter2 = this.dynamicTriggers.values().iterator();
        while (iter2.hasNext()) {
            Set group = (Set)iter2.next();
            Iterator i = group.iterator();
            while (i.hasNext()) {
                trigger = (MsgTrigger)i.next();
                if (!trigger.matchesTransaction(userName, profile, flags, warning, admin, sid)) continue;
                result.add(trigger);
            }
        }
        return result;
    }

    private Collection findEvTriggers(String profile, int event) {
        MsgTrigger trigger;
        HashSet<MsgTrigger> result = new HashSet<MsgTrigger>();
        Iterator iter = this.triggers.iterator();
        while (iter.hasNext()) {
            trigger = (MsgTrigger)iter.next();
            if (!trigger.matchesCwsEvent(profile, event)) continue;
            result.add(trigger);
        }
        iter = this.externalTriggers.iterator();
        while (iter.hasNext()) {
            trigger = (MsgTrigger)iter.next();
            if (!trigger.matchesCwsEvent(profile, event)) continue;
            result.add(trigger);
        }
        return result;
    }

    void fetchTriggerFile() {
        try {
            this.triggerFileLastCheck = System.currentTimeMillis();
            this.parent.logger.fine("Fetching '" + this.triggerFileUri + (this.triggerFileLastModified != -1L ? ", lm: " + new Date(this.triggerFileLastModified) : ""));
            String newFile = FileFetcher.fetchFile((URL)this.triggerFileUri, (String)this.triggerFileKey, (long)this.triggerFileLastModified);
            if (newFile != null) {
                if (this.triggerFile != null && this.triggerFile.hashCode() == newFile.hashCode()) {
                    this.parent.logger.fine("No changes found after fetch...");
                } else {
                    this.processTriggerFile(newFile);
                }
            } else {
                this.parent.logger.fine("Trigger file unchanged...");
            }
        }
        catch (IOException e) {
            this.parent.logger.throwing((Throwable)e);
            this.parent.logger.warning("Failed to fetch trigger file '" + this.triggerFileUri + "': " + e);
        }
    }

    void processTriggerFile(String newFile) {
        try {
            ProxyXmlConfig xml = new ProxyXmlConfig(new XMLConfig(newFile, false));
            HashSet triggers = new HashSet();
            Iterator iter = xml.getMultipleSubConfigs("msg-trigger");
            while (iter.hasNext()) {
                this.addMsgTrigger((ProxyXmlConfig)iter.next(), triggers);
            }
            this.externalTriggers = triggers;
            this.parent.logger.info(this.externalTriggers.size() + " trigger definitions parsed/updated from '" + this.triggerFileUri + "', local: " + triggers.size());
            this.triggerFile = newFile;
            this.triggerFileLastModified = System.currentTimeMillis();
        }
        catch (XMLConfigException e) {
            this.parent.logger.throwing((Throwable)e);
            this.parent.logger.warning("Unable to parse '" + this.triggerFileUri + "': " + e.getMessage());
        }
        catch (ConfigException e) {
            this.parent.logger.throwing((Throwable)e);
            this.parent.logger.warning("Error in connector file '" + this.triggerFileUri + "': " + e.getMessage());
        }
    }

    public void timeout(CronTimer cronTimer) {
        if (this.triggerFileInterval > 0 && System.currentTimeMillis() - this.triggerFileLastCheck > (long)this.triggerFileInterval) {
            new Thread("TriggerFileFetchThread"){

                public void run() {
                    TriggerMessenger.this.fetchTriggerFile();
                }
            }.start();
        }
    }

    static class TriggerMsg {
        boolean waitForZap;
        boolean store;
        String msgFormat;
        String target;

        TriggerMsg(boolean waitForZap, boolean store, String msgFormat, String target) {
            this.waitForZap = waitForZap;
            this.store = store;
            this.msgFormat = msgFormat;
            this.target = target;
        }
    }

    static class MsgTrigger {
        Set matchFlags;
        Set matchProfiles;
        Set matchUsernames;
        Set matchSids;
        Set matchEvents;
        Boolean matchAdmin;
        Boolean matchWarnings;
        Boolean matchCwsOwner;
        TriggerMsg message;

        MsgTrigger(String matchFlags, String matchProfile, String matchUsername, String matchSid, String matchAdmin, String matchWarnings, String matchCwsOwner, String matchEvents) throws ConfigException {
            if (!"".equals(matchFlags)) {
                this.matchFlags = new HashSet<String>(Arrays.asList(matchFlags.split(" ")));
            }
            if (!"".equals(matchProfile)) {
                this.matchProfiles = new HashSet<String>(Arrays.asList(matchProfile.split(" ")));
            }
            if (!"".equals(matchUsername)) {
                this.matchUsernames = new HashSet<String>(Arrays.asList(matchUsername.split(" ")));
            }
            if (!"".equals(matchSid)) {
                this.matchSids = ProxyXmlConfig.getIntTokens((String)"match-sid", (String)matchSid);
            }
            if (!"".equals(matchEvents)) {
                String[] se = matchEvents.split(" ");
                Integer[] e = new Integer[se.length];
                for (int i = 0; i < e.length; ++i) {
                    e[i] = Integer.valueOf(se[i]);
                    if (e[i] >= 0 && e[i] <= 10) continue;
                    throw new ConfigException("match-events", "Invalid event: " + e[i] + " (must be 0-8 or 10)");
                }
                this.matchEvents = new HashSet<Integer>(Arrays.asList(e));
            }
            if (!"".equals(matchAdmin)) {
                this.matchAdmin = Boolean.valueOf(matchAdmin);
            }
            if (!"".equals(matchWarnings)) {
                this.matchWarnings = Boolean.valueOf(matchWarnings);
            }
            if (!"".equals(matchCwsOwner)) {
                this.matchCwsOwner = Boolean.valueOf(matchCwsOwner);
            }
        }

        boolean matchesFlags(String flags) {
            if (this.matchFlags != null) {
                HashSet<String> fs = new HashSet<String>(Arrays.asList(flags.split("")));
                fs.remove("");
                return fs.containsAll(this.matchFlags);
            }
            return true;
        }

        boolean matchesUsername(String userName) {
            if (this.matchUsernames != null) {
                return this.matchUsernames.contains(userName);
            }
            return true;
        }

        boolean matchesProfile(String profile) {
            if (this.matchProfiles != null) {
                return this.matchProfiles.contains(profile);
            }
            return true;
        }

        boolean matchesSid(int sid) {
            if (this.matchSids != null) {
                return this.matchSids.contains(new Integer(sid));
            }
            return true;
        }

        boolean matchesEvent(int event) {
            if (this.matchEvents != null) {
                return this.matchEvents.contains(new Integer(event));
            }
            return true;
        }

        boolean matchesTransaction(String userName, String profile, String flags, boolean warning, boolean admin, int sid) {
            if (this.matchEvents != null) {
                return false;
            }
            boolean result = true;
            result = result && this.matchesUsername(userName);
            result = result && this.matchesProfile(profile);
            result = result && this.matchesFlags(flags);
            boolean bl = result = result && this.matchesSid(sid);
            if (this.matchAdmin != null) {
                boolean bl2 = result = result && admin == this.matchAdmin;
            }
            if (this.matchWarnings != null) {
                result = result && warning == this.matchWarnings;
            }
            return result;
        }

        boolean matchesCwsEvent(String profile, int event) {
            if (this.matchFlags != null || this.matchSids != null || this.matchUsernames != null) {
                return false;
            }
            boolean result = true;
            result = result && this.matchesProfile(profile);
            result = result && this.matchesEvent(event);
            return result;
        }
    }
}

