/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.tv;

import com.bowman.cardserv.tv.TvService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ServicesParser {
    private File servicesFile;
    public int conflicts;

    public ServicesParser(String fileName) {
        this.servicesFile = new File(fileName);
    }

    public Map parse(String profile, int networkId) throws IOException {
        return this.parse(null, profile, networkId);
    }

    public Map parse(String providers, String profile, int networkId) throws IOException {
        String line;
        this.conflicts = 0;
        HashSet<String> providerSet = null;
        if (providers != null) {
            String[] s = providers.toLowerCase().split(",");
            providerSet = new HashSet<String>();
            for (int i = 0; i < s.length; ++i) {
                providerSet.add(s[i].trim().toLowerCase());
            }
        }
        if (providerSet != null && providerSet.isEmpty()) {
            providerSet = null;
        }
        HashMap services = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.servicesFile), "UTF-8"));
        boolean servicesFound = false;
        while ((line = br.readLine()) != null) {
            line = line.trim();
            if (servicesFound) {
                if ("end".equals(line)) break;
                String[] tokens = line.split(":");
                TvService service = new TvService(tokens, profile);
                service.setName(br.readLine());
                service.setProviderStr(br.readLine());
                if (networkId != 0 && service.getNetworkId() != (long)networkId && providerSet == null) continue;
                if (providerSet != null) {
                    service.setNetworkId(networkId);
                }
                if (providerSet == null || providerSet.contains(service.getProvider().toLowerCase())) {
                    this.addService(services, service);
                }
            }
            if (!"services".equals(line)) continue;
            servicesFound = true;
        }
        return services;
    }

    public int getConflicts() {
        return this.conflicts;
    }

    private void addService(Map services, TvService service) {
        if (!service.isTv()) {
            return;
        }
        Integer i = new Integer(service.getId());
        if (services.containsKey(i)) {
            TvService existing = (TvService)services.get(i);
            if (!service.getName().equalsIgnoreCase(existing.getName())) {
                existing.addConflicting(service);
                ++this.conflicts;
            }
        } else {
            services.put(i, service);
        }
    }
}

