/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.tv.TvService;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class EcmTransaction {
    private Set trFlags = new LinkedHashSet();
    private CamdNetMessage request;
    private CamdNetMessage reply;
    private int duration;
    private String profileName;

    public EcmTransaction(CamdNetMessage request) {
        this.request = request;
        this.profileName = request.getProfileName();
    }

    public long getReadTime() {
        return this.request.getTimeStamp();
    }

    public int getServiceId() {
        return this.request.getServiceId();
    }

    public int getReplyServiceId() {
        if (this.reply != null) {
            return this.reply.getServiceId();
        }
        return -1;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getFlags() {
        if (this.trFlags.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.trFlags.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public String getFilteredBy() {
        return this.request.getFilteredBy();
    }

    public void setFlag(char f) {
        this.trFlags.add(String.valueOf(f));
    }

    public void end(CamdNetMessage reply, int status) {
        long now = System.currentTimeMillis();
        this.duration = (int)(now - this.request.getTimeStamp());
        this.request.setClientTime(now - reply.getTimeStamp());
        if (reply.isInstant()) {
            this.setFlag('I');
        }
        if (reply.isEmpty()) {
            this.setFlag('E');
        }
        if (status < 0) {
            this.setFlag('D');
        }
        this.reply = reply;
    }

    public String getReplyData() {
        if (this.reply == null) {
            return null;
        }
        return DESUtil.bytesToString(this.reply.getCustomData());
    }

    public String getProviderContext() {
        if (this.reply == null) {
            return null;
        }
        Set providers = this.reply.getProviderContext();
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        return (String)providers.iterator().next();
    }

    public void setRequest(CamdNetMessage request) {
        this.request = request;
    }

    public CamdNetMessage getRequest() {
        return this.request;
    }

    public CamdNetMessage getReply() {
        return this.reply;
    }

    public Properties getTimings() {
        Properties p = new Properties();
        p.setProperty("time-cache", String.valueOf(this.request.getCacheTime()));
        p.setProperty("time-queue", String.valueOf(this.request.getQueueTime()));
        p.setProperty("time-cws", String.valueOf(this.request.getCWSTime()));
        p.setProperty("time-client", String.valueOf(this.request.getClientTime()));
        return p;
    }

    public String getConnectorName() {
        if (this.reply != null && this.reply.getConnectorName() != null) {
            return this.reply.getConnectorName();
        }
        if (this.request != null && this.request.getConnectorName() != null) {
            return this.request.getConnectorName();
        }
        return null;
    }

    public TvService getService() {
        return ProxyConfig.getInstance().getService(this.request);
    }
}

