/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.CamdConstants;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.EcmTransactionListener;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.session.EcmTransaction;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.TimedAverageList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSession
implements CamdConstants,
ProxySession,
Runnable {
    protected static final int MAX_LOG_SIZE = 100;
    private Set msgListeners = new HashSet();
    private Set trListeners = new HashSet();
    int sessionId;
    int maxPending;
    int maxSessions;
    String user;
    String loginName;
    String clientId;
    String remoteAddress;
    boolean userDebug;
    Set allowedConnectors;
    Set mappedProfiles;
    Set allowedProfiles;
    Map allowedServices;
    Map blockedServices;
    int allowedRate;
    private long connectTimeStamp;
    private long lastZapTimeStamp;
    int msgCount;
    int ecmCount;
    private final Map transactions = new LinkedHashMap();
    private EcmTransaction lastTransaction;
    private EcmTransaction currentTransaction;
    Thread sessionThread;
    private TimedAverageList avgList;
    ListenPort listenPort;
    ProxyLogger logger;
    boolean alive;

    public AbstractSession(ListenPort listenPort, CamdMessageListener listener) {
        this.listenPort = listenPort;
        this.sessionId = SessionManager.getInstance().getNewSessionId();
        if (listener != null) {
            this.addCamdMessageListener(listener);
        }
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName(), this.getLabel());
        this.avgList = new TimedAverageList(60);
        this.maxPending = ProxyConfig.getInstance().getMaxPending();
        this.connectTimeStamp = System.currentTimeMillis();
    }

    public int getId() {
        return this.sessionId;
    }

    public void addCamdMessageListener(CamdMessageListener listener) {
        this.msgListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCamdMessage(CamdNetMessage msg, boolean sent) {
        if (msg == null) {
            return;
        }
        Iterator iter = this.msgListeners.iterator();
        while (iter.hasNext()) {
            try {
                if (!sent) {
                    if (msg.isEcm()) {
                        Map map = this.transactions;
                        synchronized (map) {
                            if (this.transactions.size() >= this.maxPending) {
                                if (ProxyConfig.getInstance().isDebug()) {
                                    this.logger.warning("max-pending exceeded for user '" + this.user + "', replying with empty...");
                                } else {
                                    this.logger.fine("max-pending exceeded for user '" + this.user + "', replying with empty...");
                                }
                                try {
                                    Thread.sleep(100L);
                                    this.sendEcmReplyNative(msg, msg.getEmptyReply());
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                msg.setFilteredBy("Max-pending exceeded");
                            } else if (this.transactions.containsKey(msg)) {
                                if (ProxyConfig.getInstance().isDebug()) {
                                    this.logger.warning("Duplicate request received for user '" + this.user + "', already pending: " + msg);
                                } else {
                                    this.logger.fine("Duplicate request received for user '" + this.user + "', already pending: " + msg);
                                }
                                this.currentTransaction = this.getTransaction(msg);
                                this.currentTransaction.setRequest(msg);
                                msg.setFilteredBy("Duplicate ECM");
                            } else {
                                this.currentTransaction = new EcmTransaction(msg);
                                this.transactions.put(msg, this.currentTransaction);
                            }
                        }
                    }
                    ((CamdMessageListener)iter.next()).messageReceived(this, msg);
                    continue;
                }
                ((CamdMessageListener)iter.next()).messageSent(this, msg);
            }
            catch (Throwable t) {
                this.logger.severe("Exception in CamdNetMessage dispatching: " + t, t);
            }
        }
    }

    public void addTransactionListener(EcmTransactionListener listener) {
        this.trListeners.add(listener);
    }

    void fireTransactionCompleted(EcmTransaction transaction) {
        if ((this.userDebug || this.getProfile().isDebug()) && this.user != null) {
            Iterator iter = this.trListeners.iterator();
            while (iter.hasNext()) {
                try {
                    ((EcmTransactionListener)iter.next()).transactionCompleted(transaction, this);
                }
                catch (Throwable t) {
                    this.logger.severe("Exception in EcmTransaction dispatching: " + t, t);
                }
            }
        }
    }

    void setupLimits(UserManager um) {
        this.allowedServices = null;
        this.blockedServices = null;
        if (this.getProfile() == CaProfile.MULTIPLE) {
            if (this.mappedProfiles != null) {
                Iterator iter = this.mappedProfiles.iterator();
                while (iter.hasNext()) {
                    CaProfile profile = (CaProfile)iter.next();
                    this.addSidList(um, profile.getName(), true);
                    this.addSidList(um, profile.getName(), false);
                }
            }
        } else {
            this.addSidList(um, this.getProfile().getName(), true);
            this.addSidList(um, this.getProfile().getName(), false);
        }
        this.allowedConnectors = um.getAllowedConnectors(this.user);
        this.allowedRate = um.getAllowedEcmRate(this.user);
        this.allowedProfiles = um.getAllowedProfiles(this.user);
        if (this.allowedRate != -1) {
            this.allowedRate *= 1000;
        }
        if (um.isAdmin(this.user)) {
            this.maxPending = 30;
        }
        this.userDebug = um.isDebug(this.user);
    }

    private void addSidList(UserManager um, String profileName, boolean allow) {
        Set services;
        Set set = services = allow ? um.getAllowedServices(this.user, profileName) : um.getBlockedServices(this.user, profileName);
        if (services != null) {
            if (allow) {
                if (this.allowedServices == null) {
                    this.allowedServices = new HashMap();
                }
                this.allowedServices.put(profileName, services);
            } else {
                if (this.blockedServices == null) {
                    this.blockedServices = new HashMap();
                }
                this.blockedServices.put(profileName, services);
            }
        }
    }

    boolean checkLimits(CamdNetMessage msg) {
        if (msg.isEcm()) {
            Set services;
            CaProfile profile;
            String profileName = this.getProfileName();
            if (this.getProfile() == CaProfile.MULTIPLE && (profile = ProxyConfig.getInstance().getProfileById(msg.getNetworkId(), msg.getCaId())) != null) {
                profileName = profile.getName();
            }
            msg.setProfileName(profileName);
            long now = System.currentTimeMillis();
            long interval = now - (this.lastTransaction == null ? this.connectTimeStamp : this.lastTransaction.getReadTime());
            int size = this.avgList.size(true);
            if (size < 1) {
                size = 1;
            }
            int rate = this.avgList.getMaxAge() / size;
            if (this.allowedRate != -1 && rate > 0 && rate < this.allowedRate) {
                this.logger.warning(this + " for user '" + this.user + "' exceeded rate limit: " + rate + " (limit: " + this.allowedRate + ")");
                msg.setFilteredBy("Rate limit exceeded: " + rate + " > " + this.allowedRate);
                return false;
            }
            if (interval < 60000L) {
                this.avgList.addRecord(now, (int)interval);
            }
            if (!this.allowedProfiles.isEmpty() && !this.allowedProfiles.contains(profileName)) {
                msg.setFilteredBy("Profile not allowed: " + profileName);
                return false;
            }
            if (this.allowedServices != null && (services = (Set)this.allowedServices.get(msg.getProfileName())) != null && !services.contains(new Integer(msg.getServiceId()))) {
                String name = ProxyConfig.getInstance().getServiceName(msg);
                this.logger.info(name + " blocked for: " + this);
                msg.setFilteredBy("Service not in allow list: " + name);
                return false;
            }
            if (this.blockedServices != null && (services = (Set)this.blockedServices.get(msg.getProfileName())).contains(new Integer(msg.getServiceId()))) {
                String name = ProxyConfig.getInstance().getServiceName(msg);
                this.logger.info(name + " blocked for: " + this);
                msg.setFilteredBy("Service in block list: " + name);
                return false;
            }
        }
        return true;
    }

    public boolean isActive() {
        return this.getTrIdleTime() < 45000L;
    }

    long getTrIdleTime() {
        if (this.currentTransaction == null) {
            return System.currentTimeMillis() - this.connectTimeStamp;
        }
        return System.currentTimeMillis() - this.currentTransaction.getReadTime();
    }

    public long getIdleTime() {
        return this.getTrIdleTime();
    }

    public String getUser() {
        return this.user;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public boolean isTempUser() {
        if (this.loginName == null) {
            return false;
        }
        return !this.loginName.equalsIgnoreCase(this.user);
    }

    public String getClientId() {
        return this.clientId;
    }

    public ListenPort getListenPort() {
        return this.listenPort;
    }

    public TvService getCurrentService() {
        if (this.currentTransaction == null) {
            return ProxyConfig.getInstance().getService(this.getProfileName(), -1);
        }
        return this.currentTransaction.getService();
    }

    public TvService getLastTransactionService() {
        if (this.lastTransaction == null) {
            return ProxyConfig.getInstance().getService(this.getProfileName(), -1);
        }
        return this.lastTransaction.getService();
    }

    public int getPendingCount() {
        return this.transactions.size();
    }

    public int getKeepAliveCount() {
        return 0;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public int getEcmCount() {
        return this.ecmCount;
    }

    public int getEmmCount() {
        return 0;
    }

    public int getAverageEcmInterval() {
        if (this.ecmCount < 1) {
            return -1;
        }
        int current = this.avgList.getAverage(true);
        if (current == 0) {
            return this.avgList.getAverage(false) / 1000;
        }
        return current / 1000;
    }

    public int getTransactionTime() {
        return this.currentTransaction == null ? -1 : (int)(System.currentTimeMillis() - this.currentTransaction.getReadTime());
    }

    public int getLastTransactionTime() {
        return this.lastTransaction == null ? -1 : this.lastTransaction.getDuration();
    }

    public String getLastTransactionFlags() {
        return this.lastTransaction == null ? "" : this.lastTransaction.getFlags();
    }

    public String getRemoteAddress() {
        if (this.remoteAddress == null) {
            return "0.0.0.0";
        }
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlag(CamdNetMessage request, char f) {
        if (request.isEcm()) {
            Map map = this.transactions;
            synchronized (map) {
                if (!this.transactions.containsKey(request)) {
                    this.logger.fine("Attempt to set flag '" + f + "' on non-existant transaction: " + request);
                } else {
                    this.getTransaction(request).setFlag(f);
                    if (f == 'Z') {
                        this.lastZapTimeStamp = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    EcmTransaction getTransaction(CamdNetMessage request) {
        return (EcmTransaction)this.transactions.get(request);
    }

    public boolean isInterested(CamdNetMessage ecmRequest) {
        if (!this.isConnected()) {
            return false;
        }
        return this.transactions.containsKey(ecmRequest);
    }

    public int sendEcmReply(CamdNetMessage ecmRequest, CamdNetMessage ecmReply) {
        if (!this.isInterested(ecmRequest)) {
            this.logger.fine("Not interested in reply: " + ecmReply);
            return -1;
        }
        if (ecmReply.getCaId() != 0 && ecmRequest.getCaId() != ecmReply.getCaId()) {
            this.setFlag(ecmRequest, 'M');
            String s = "Ca-id mismatch, response (from " + ecmReply.getConnectorName() + ") had ca-id " + Integer.toHexString(ecmReply.getCaId()) + " but request was for profile: " + ecmRequest.getProfileName() + " (from user '" + this.user + "' - " + this.clientId + ")";
            if (ProxyConfig.getInstance().isBlockCaidMismatch()) {
                ecmReply = ecmRequest.getEmptyReply();
                this.logger.warning(s);
            } else {
                this.logger.fine(s);
            }
        } else if (ecmReply.getProfileName() != null && !ecmReply.getProfileName().equals(ecmRequest.getProfileName())) {
            this.setFlag(ecmRequest, 'M');
            String s = "Profile mismatch, response (from " + ecmReply.getConnectorName() + ") had profile " + ecmReply.getProfileName() + " but request was for profile: " + ecmRequest.getProfileName() + " (from user '" + this.user + "' - " + this.clientId + ")";
            if (ProxyConfig.getInstance().isBlockCaidMismatch()) {
                ecmReply = ecmRequest.getEmptyReply();
                this.logger.warning(s);
            } else {
                this.logger.fine(s);
            }
        }
        ecmRequest = ((EcmTransaction)this.transactions.get(ecmRequest)).getRequest();
        if (ecmRequest.getCommandTag() != ecmReply.getCommandTag()) {
            this.logger.fine("Table-id mismatch, response (from " + ecmReply.getConnectorName() + ") had table-id " + Integer.toHexString(ecmReply.getCommandTag()) + " but request had " + Integer.toHexString(ecmRequest.getCommandTag()) + " (from user '" + this.user + "' - " + this.clientId + ")");
            ecmReply.setCommandTag(ecmRequest.getCommandTag());
        }
        return this.sendEcmReplyNative(ecmRequest, ecmReply);
    }

    protected abstract int sendEcmReplyNative(CamdNetMessage var1, CamdNetMessage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTransaction(CamdNetMessage request, CamdNetMessage reply, int status) {
        Map map = this.transactions;
        synchronized (map) {
            EcmTransaction tr = this.getTransaction(request);
            if (tr == null) {
                if (this.lastTransaction != null && this.lastTransaction.getRequest().equals(request)) {
                    this.logger.fine("Attempt to end already ended transaction: " + request + " (" + this.lastTransaction.getFlags() + ")");
                } else {
                    this.logger.fine("Attempt to end non-existant transaction: " + request);
                }
            } else {
                tr.end(reply, status);
                this.transactions.remove(request);
                this.lastTransaction = tr;
                this.fireTransactionCompleted(tr);
            }
            if (status != -1) {
                this.fireCamdMessage(reply, true);
            }
        }
    }

    void endSession() {
        String summary = (this.getUser() == null ? "ended" : this.getUser() + " - ended") + " [pending transactions: " + this.transactions.size() + " idle time: " + this.getTrIdleTime() + " ecm count: " + this.ecmCount + " total count: " + this.msgCount + "]";
        if (this.getUser() != null) {
            if (ProxyConfig.getInstance().getUserManager().isDebug(this.getUser())) {
                this.logger.info(summary);
            }
        } else {
            this.logger.fine(summary);
        }
        SessionManager.getInstance().removeSession(this);
        this.transactions.clear();
        this.sessionThread = null;
    }

    public long getConnectTimeStamp() {
        return this.connectTimeStamp;
    }

    public long getLastZapTimeStamp() {
        return this.lastZapTimeStamp;
    }

    public Set getAllowedConnectors() {
        return this.allowedConnectors;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public CaProfile getProfile() {
        return this.listenPort.getProfile();
    }

    public String getProfileName() {
        if (this.getProfile() == null) {
            return "?";
        }
        return this.getProfile().getName();
    }

    public String getLabel() {
        return this.getProtocol() + "Session[" + this.sessionId + ":" + this.getProfileName() + "]";
    }

    public abstract String getProtocol();

    public String toString() {
        return this.getUser() + " (" + this.getLabel() + ")";
    }
}

