/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.util.Globber;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IpCheckServerSocket
extends ServerSocket {
    private static ProxyLogger logger;
    private static InetAddress bindAddress;
    private static Set ipMasks;

    public static void addIpMask(String mask) {
        ipMasks.add(mask);
    }

    public static void clearIpMasks() {
        ipMasks.clear();
    }

    public static void setBindAddress(InetAddress bindAddr) {
        bindAddress = bindAddr;
    }

    public IpCheckServerSocket(int port) throws IOException {
        super(port, 50, bindAddress);
    }

    public Socket accept() throws IOException {
        Socket s = super.accept();
        Iterator iter = ipMasks.iterator();
        while (iter.hasNext()) {
            String mask = (String)iter.next();
            if (!Globber.match(mask, s.getInetAddress().getHostAddress(), false)) continue;
            return s;
        }
        if (logger != null) {
            logger.warning("RMI connection from unknown IP denied: " + s.getInetAddress().getHostAddress());
        }
        s.close();
        return this.accept();
    }

    static {
        try {
            logger = ProxyLogger.getProxyLogger(RemoteHandler.class.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ipMasks = new HashSet();
    }
}

