/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.tv.TvService;
import java.io.Serializable;

public class ServiceMapping
implements Serializable,
Comparable {
    public static final int NO_PROVIDER = 0xFFFFFF;
    public int serviceId;
    private long customData;

    public ServiceMapping(int serviceId) {
        this.serviceId = serviceId;
        this.customData = -1L;
    }

    public ServiceMapping(int serviceId, long customData) {
        this.serviceId = serviceId;
        this.customData = customData & 0xFFFFFFFFFFL;
    }

    public ServiceMapping(CamdNetMessage msg) {
        CaProfile profile;
        this.serviceId = msg.getServiceId();
        this.setCustomId(msg.getCustomId());
        this.setProviderIdent(0xFFFFFF);
        if (msg.getProfileName() != null && (profile = ProxyConfig.getInstance().getProfile(msg.getProfileName())) != null && profile.isRequireProviderMatch()) {
            this.setProviderIdent(msg.getProviderIdent());
        }
    }

    public ServiceMapping(TvService service) {
        this.serviceId = service.getId();
        this.customData = service.getCustomData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMapping that = (ServiceMapping)o;
        if (this.customData != that.customData) {
            return false;
        }
        return this.serviceId == that.serviceId;
    }

    public int hashCode() {
        int result = this.serviceId;
        result = 31 * result + (int)(this.customData ^ this.customData >>> 32);
        return result;
    }

    public String toString() {
        return DESUtil.intToHexString(this.serviceId, 4) + (this.getCustomId() != 0 ? ":" + DESUtil.intToHexString(this.getCustomId(), 4) : "") + (this.getProviderIdent() != 0xFFFFFF ? ":" + DESUtil.intToHexString(this.getProviderIdent(), 6) : "");
    }

    public int compareTo(Object o) {
        int os = ((ServiceMapping)o).serviceId;
        return this.serviceId < os ? -1 : (this.serviceId == os ? 0 : 1);
    }

    public int getCustomId() {
        return (int)(this.customData & 0xFFFFL);
    }

    public void setCustomId(int customId) {
        this.customData &= 0xFFFFFF0000L;
        this.customData |= (long)(customId & 0xFFFF);
    }

    public int getProviderIdent() {
        return (int)(this.customData >> 16 & 0xFFFFFFL);
    }

    public void setProviderIdent(int ident) {
        this.customData &= 0xFFFFL;
        this.customData |= ((long)ident & 0xFFFFFFL) << 16;
    }

    public long getCustomData() {
        return this.customData;
    }
}

