/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.cws.ConnectorSelection;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.session.CspSession;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CwsServiceMapper
implements XmlConfigurable {
    private static final String CACHE_FILESUFFIX = "_servicemap.dat";
    private ProxyLogger logger;
    private ProxyConfig config;
    private boolean enabled;
    private Map connectors = new HashMap();
    private Map canDecodeMap = new HashMap();
    private Map cannotDecodeMap = new HashMap();
    private Map failureCountMap = new HashMap();
    private Map failureMap = new HashMap();
    private Set rediscoverSet = new HashSet();
    Map overrideCanDecodeMap = new HashMap();
    Map overrideCannotDecodeMap = new HashMap();
    Set exclusiveConnectors = new HashSet();
    private long cacheTimeStamp;
    private boolean cacheUpdated;
    private long cacheSaveAge;
    private int autoExcludeThreshold;
    private boolean autoDiscoverAll;
    private boolean retryLostServices;
    private boolean hideUnknownServices;
    private boolean hideDisabledConnectors;
    private boolean hideRadioServices;
    private boolean logMissingSid;
    private boolean bcMissingSid;
    private boolean redundantForwarding;
    private File cacheDir;
    private Set resetServices = new HashSet();
    private Set blockedServices = new HashSet();
    private Set allowedServices = new HashSet();
    private Set unknownServices = new LinkedHashSet();
    private String resetSrvStr;
    private String blockedSrvStr;
    private String allowedSrvStr;
    private CaProfile profile;
    private CwsConnectorManager cm;

    public CwsServiceMapper(CaProfile profile, CwsConnectorManager cm) {
        this.profile = profile;
        this.cm = cm;
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName(), "ServiceMapper[" + profile.getName() + "]");
        this.config = ProxyConfig.getInstance();
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        if (!this.enabled) {
            this.logger.warning("Service mapping disabled for profile: " + this.profile.getName());
            return;
        }
        this.cacheSaveAge = xml.getTimeValue("cache-save-age", 300, "s");
        this.cacheDir = new File(xml.getFileValue("cache-dir", "cache", true, true));
        this.autoDiscoverAll = "true".equalsIgnoreCase(xml.getStringValue("auto-map-services", "true"));
        this.logMissingSid = "true".equalsIgnoreCase(xml.getStringValue("log-missing-sid", "true"));
        this.bcMissingSid = "true".equalsIgnoreCase(xml.getStringValue("broadcast-missing-sid", "false"));
        this.redundantForwarding = "true".equalsIgnoreCase(xml.getStringValue("redundant-forwarding", "false"));
        String unknownList = null;
        try {
            unknownList = xml.getStringValue("dummy-services");
        }
        catch (ConfigException e) {
            this.unknownServices = new HashSet();
        }
        if (unknownList != null) {
            this.unknownServices = ProxyXmlConfig.getIntTokens("dummy-services", unknownList);
        }
        try {
            int unknownSid = Integer.parseInt(xml.getStringValue("unknown-sid"), 16);
            this.unknownServices.add(new Integer(unknownSid));
        }
        catch (ConfigException e) {
        }
        catch (NumberFormatException e) {
            throw new ConfigException(xml.getFullName(), "unknown-sid", "Bad hex integer value: " + e.getMessage());
        }
        String resetList = null;
        try {
            resetList = xml.getStringValue("reset-services");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.resetServices = resetList != null ? ProxyConfig.getServiceTokens("reset-services", resetList, false) : Collections.EMPTY_SET;
        this.resetSrvStr = null;
        String blockedList = null;
        try {
            blockedList = xml.getStringValue("block-services");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.blockedServices = blockedList != null ? ProxyConfig.getServiceTokens("block-services", blockedList, false) : new HashSet();
        this.blockedSrvStr = null;
        String allowedList = null;
        try {
            allowedList = xml.getStringValue("allow-services");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.allowedServices = allowedList != null ? ProxyConfig.getServiceTokens("allow-services", allowedList, true) : Collections.EMPTY_SET;
        this.allowedSrvStr = null;
        this.autoExcludeThreshold = xml.getIntValue("auto-reset-threshold", -1);
        this.retryLostServices = "true".equalsIgnoreCase(xml.getStringValue("retry-lost-services", "true"));
        this.hideUnknownServices = "true".equalsIgnoreCase(xml.getStringValue("hide-unknown-services", "false"));
        this.hideRadioServices = "true".equalsIgnoreCase(xml.getStringValue("hide-radio-services", "true"));
        this.hideDisabledConnectors = "true".equalsIgnoreCase(xml.getStringValue("hide-disabled-connectors", "false"));
        this.overrideCanDecodeMap.clear();
        this.overrideCannotDecodeMap.clear();
    }

    public String getResetServicesStr() {
        if (this.resetSrvStr != null) {
            return this.resetSrvStr;
        }
        if (!this.resetServices.isEmpty()) {
            this.resetSrvStr = this.serviceTokensToStr(this.resetServices);
        }
        return this.resetSrvStr;
    }

    public String getBlockedServicesStr() {
        if (this.blockedSrvStr != null) {
            return this.blockedSrvStr;
        }
        if (!this.blockedServices.isEmpty()) {
            this.blockedSrvStr = this.serviceTokensToStr(this.blockedServices);
        }
        return this.blockedSrvStr;
    }

    public String getAllowedServicesStr() {
        if (this.allowedSrvStr != null) {
            return this.allowedSrvStr;
        }
        if (!this.allowedServices.isEmpty()) {
            this.allowedSrvStr = this.serviceTokensToStr(this.allowedServices);
        }
        return this.allowedSrvStr;
    }

    private String serviceTokensToStr(Set set) {
        if (set.size() > 25) {
            return "[ ... " + set.size() + " ... ]";
        }
        StringBuffer sb = new StringBuffer("[");
        ProxyConfig config = ProxyConfig.getInstance();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ServiceMapping sm = (ServiceMapping)iter.next();
            TvService ts = config.getService(this.profile.getName(), sm);
            sb.append(ts.getName());
            if (!ts.isUnknown()) {
                sb.append(" (").append(Integer.toHexString(ts.getId())).append(')');
            }
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    synchronized void loadServiceMaps() {
        this.cacheUpdated = false;
        this.cacheTimeStamp = System.currentTimeMillis();
        try {
            File mapFile = new File(this.cacheDir, this.profile.getName() + CACHE_FILESUFFIX);
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(mapFile)));
            this.canDecodeMap = (Map)ois.readObject();
            this.cannotDecodeMap = (Map)ois.readObject();
            try {
                this.rediscoverSet = (Set)ois.readObject();
            }
            catch (Exception e) {
                this.rediscoverSet = new HashSet();
            }
            ois.close();
            this.convertMap(this.canDecodeMap);
            this.convertMap(this.cannotDecodeMap);
            this.logger.info("Loaded service maps. Can decode [" + this.canDecodeMap.size() + "] services, cannot decode [" + this.cannotDecodeMap.size() + "], rediscover tasks: [" + this.rediscoverSet.size() + "]");
        }
        catch (FileNotFoundException e) {
            this.logger.fine("No service map cache file found");
        }
        catch (Exception e) {
            this.logger.severe("Failed to load channel map cache: " + e, e);
        }
    }

    private void convertMap(Map map) {
        Iterator iter = new ArrayList(map.keySet()).iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            if (!(k instanceof Integer)) continue;
            Object v = map.remove(k);
            map.put(new ServiceMapping((Integer)k, 0L), v);
        }
    }

    synchronized void saveServiceMaps() {
        this.saveServiceMaps(false);
    }

    synchronized void saveServiceMaps(boolean force) {
        long now;
        if (!this.enabled) {
            return;
        }
        if (force) {
            this.cacheTimeStamp = 0L;
        }
        if ((now = System.currentTimeMillis()) - this.cacheTimeStamp < this.cacheSaveAge) {
            return;
        }
        this.logger.fine("Cache is older than " + this.cacheSaveAge / 1000L + " seconds, saving...");
        if (this.cacheUpdated) {
            this.cacheUpdated = false;
            try {
                File mapFile = new File(this.cacheDir, this.profile.getName() + CACHE_FILESUFFIX);
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(mapFile)));
                oos.writeObject(this.canDecodeMap);
                oos.writeObject(this.cannotDecodeMap);
                oos.writeObject(this.rediscoverSet);
                oos.flush();
                oos.close();
            }
            catch (IOException e) {
                this.logger.severe("Failed to save service map cache: " + e);
                this.logger.throwing(e);
            }
            catch (Exception e) {
                this.logger.warning("Failed to save service map cache: " + e);
                this.logger.throwing(e);
            }
        } else {
            this.logger.fine("Cache not changed, skipping...");
        }
        this.cacheTimeStamp = now;
    }

    CwsConnector getCwsConnector() {
        List ready = this.getReadyConnectors();
        if (ready.isEmpty()) {
            return null;
        }
        CwsConnector[] conns = CwsServiceMapper.selectLeastLoaded(ready);
        if (conns == null || conns.length == 0) {
            return null;
        }
        return conns[0];
    }

    Map getConnectors() {
        HashMap<String, CwsConnector> tmp = new HashMap<String, CwsConnector>();
        Iterator iter = this.connectors.values().iterator();
        while (iter.hasNext()) {
            CwsConnector conn = (CwsConnector)iter.next();
            if (!conn.isEnabled() && this.hideDisabledConnectors) continue;
            tmp.put(conn.getName(), conn);
        }
        return tmp;
    }

    List getConnectors(ServiceMapping id, boolean canDecode) {
        ArrayList names = (ArrayList)(canDecode ? this.canDecodeMap.get(id) : this.cannotDecodeMap.get(id));
        names = names == null ? new ArrayList() : new ArrayList(names);
        names.addAll(this.getOverrideConnectors(id, canDecode));
        if (names.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        names.removeAll(this.getOverrideConnectors(id, !canDecode));
        ArrayList<CwsConnector> tmp = new ArrayList<CwsConnector>();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            CwsConnector conn = (CwsConnector)this.connectors.get(name);
            if (conn == null) {
                conn = (CwsConnector)this.cm.getMultiConnectors(this.profile.getNetworkId(), this.profile.getCaId()).get(name);
            }
            if (conn == null) {
                List l = (List)(canDecode ? this.canDecodeMap.get(id) : this.cannotDecodeMap.get(id));
                if (l == null || !l.remove(name)) continue;
                this.logger.info("Removing unknown connector name '" + name + "' from service maps for service [" + this.config.getServiceName(this.profile.getName(), id.serviceId) + "]");
                continue;
            }
            if (!conn.isReady()) continue;
            tmp.add(conn);
        }
        return tmp;
    }

    List getOverrideConnectors(ServiceMapping id, boolean canDecode) {
        List names = (List)(canDecode ? this.overrideCanDecodeMap.get(id) : this.overrideCannotDecodeMap.get(id));
        if (names == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(names);
    }

    boolean isServiceOverridden(String cwsName, ServiceMapping id) {
        return this.getOverrideConnectors(id, true).indexOf(cwsName) != -1;
    }

    List getServicesForConnector(String cwsName, boolean canDecode, boolean raw) {
        ArrayList<Comparable> services = new ArrayList<Comparable>();
        if (!this.enabled) {
            return services;
        }
        Map map = canDecode ? this.canDecodeMap : this.cannotDecodeMap;
        Map overrideMap1 = canDecode ? this.overrideCanDecodeMap : this.overrideCannotDecodeMap;
        Map overrideMap2 = !canDecode ? this.overrideCanDecodeMap : this.overrideCannotDecodeMap;
        HashSet sids = new HashSet(map.keySet());
        sids.addAll(overrideMap1.keySet());
        Iterator iter = sids.iterator();
        while (iter.hasNext()) {
            ServiceMapping id = (ServiceMapping)iter.next();
            if (id.getCustomData() == -1L) continue;
            HashSet tmp = new HashSet();
            if (map.containsKey(id)) {
                try {
                    tmp.addAll((List)map.get(id));
                }
                catch (Exception e) {
                    tmp.addAll((List)map.get(id));
                }
            }
            if (overrideMap1.containsKey(id)) {
                tmp.addAll((List)overrideMap1.get(id));
            }
            if (overrideMap2.containsKey(id)) {
                tmp.removeAll((List)overrideMap2.get(id));
            }
            if (!tmp.contains(cwsName)) continue;
            if (raw) {
                services.add(id);
                continue;
            }
            TvService service = this.config.getService(this.profile.getName(), id);
            if (service == null) {
                if (this.hideUnknownServices) continue;
                services.add(TvService.getUnknownService(this.profile.getName(), id.serviceId));
                continue;
            }
            if (!service.isTv() || this.hideRadioServices && service.getType() == 2) continue;
            services.add(service);
        }
        if (!raw) {
            Collections.sort(services);
        }
        return services;
    }

    List getReadyConnectors() {
        ArrayList<CwsConnector> tmp = new ArrayList<CwsConnector>();
        Iterator iter = this.connectors.values().iterator();
        while (iter.hasNext()) {
            CwsConnector conn = (CwsConnector)iter.next();
            if (!conn.isReady()) continue;
            tmp.add(conn);
        }
        return tmp;
    }

    private List getConnectorsUnknownChannelStatus(ServiceMapping id) {
        CwsConnector conn;
        ArrayList<CwsConnector> tmp = new ArrayList<CwsConnector>();
        if (!this.enabled) {
            return tmp;
        }
        Iterator<Object> iter = this.getReadyConnectors().iterator();
        while (iter.hasNext()) {
            conn = (CwsConnector)iter.next();
            if (this.canDecode(conn, id) != null) continue;
            tmp.add(conn);
        }
        iter = this.cm.getMultiConnectors(this.profile.getNetworkId(), this.profile.getCaId()).values().iterator();
        while (iter.hasNext()) {
            conn = (CwsConnector)iter.next();
            if (this.canDecode(conn, id) != null) continue;
            tmp.add(conn);
        }
        return tmp;
    }

    List getConnectorsForProvider(String provider) {
        ArrayList<CwsConnector> tmp = new ArrayList<CwsConnector>();
        Iterator iter = this.getReadyConnectors().iterator();
        while (iter.hasNext()) {
            CwsConnector conn = (CwsConnector)iter.next();
            HashSet<String> providers = new HashSet<String>(Arrays.asList(conn.getRemoteCard().getProviders()));
            if (!providers.contains(provider)) continue;
            tmp.add(conn);
        }
        return tmp;
    }

    ConnectorSelection getConnectorsForService(ServiceMapping id, Set allowedConnectorNames) {
        if (id.serviceId > 0) {
            if (id.getCustomId() == 0 && id.getProviderIdent() == 0xFFFFFF) {
                if (!this.allowedServices.isEmpty() && !this.allowedServices.contains(id)) {
                    return ConnectorSelection.EMPTY;
                }
                if (this.blockedServices.contains(id)) {
                    return ConnectorSelection.EMPTY;
                }
            } else {
                ServiceMapping sm = new ServiceMapping(id.serviceId, 0L);
                sm.setProviderIdent(0xFFFFFF);
                if (!this.allowedServices.isEmpty() && !this.allowedServices.contains(sm)) {
                    return ConnectorSelection.EMPTY;
                }
                if (this.blockedServices.contains(sm) || this.blockedServices.contains(id)) {
                    return ConnectorSelection.EMPTY;
                }
            }
        }
        if (!this.enabled) {
            id.serviceId = -1;
        }
        ConnectorSelection result = this.getConnectorsForServiceInternal(id, allowedConnectorNames);
        if (this.isServiceUnknown(id.serviceId)) {
            return result;
        }
        if ((result == null || result.isEmpty()) && id.getCustomId() == 0) {
            this.incFailures(id);
        }
        if (this.autoExcludeThreshold > 0 && this.getFailures(id) >= this.autoExcludeThreshold) {
            this.logger.info(this.autoExcludeThreshold + " failure(s) for service [" + this.config.getServiceName(this.profile.getName(), id.serviceId) + "], resetting status...");
            this.cannotDecodeMap.remove(id);
            this.failureCountMap.remove(id);
        }
        return result;
    }

    protected boolean isServiceUnknown(int sid) {
        return sid <= 0 || this.unknownServices.contains(new Integer(sid));
    }

    protected int getUnknownSid() {
        if (this.unknownServices.isEmpty()) {
            return 0;
        }
        return (Integer)this.unknownServices.iterator().next();
    }

    private ConnectorSelection getConnectorsForServiceInternal(ServiceMapping id, Set allowedConnectorNames) {
        CwsConnector leastLoaded;
        CwsConnector[] twoLeastLoaded;
        CwsConnector cws;
        Iterator iter;
        List canDecode;
        String serviceName = this.config.getServiceName(this.profile.getName(), id);
        boolean serviceUnknown = false;
        if (this.isServiceUnknown(id.serviceId)) {
            if (this.logMissingSid && this.enabled) {
                if (id.serviceId == 0) {
                    this.logger.warning("Connector for service id [0] requested, no sid in ecm request?");
                } else {
                    this.logger.warning("Connector for unknown sid [" + id + "] requested.");
                }
            }
            serviceUnknown = true;
        }
        List list = canDecode = serviceUnknown ? this.getReadyConnectors() : this.getConnectors(id, true);
        if (serviceUnknown) {
            canDecode.addAll(this.cm.getMultiConnectors(this.profile.getNetworkId(), this.profile.getCaId()).values());
        }
        List unknown = null;
        ArrayList<CwsConnector> secondary = null;
        if (!serviceUnknown) {
            List ready;
            if (canDecode.isEmpty() && !(ready = this.getReadyConnectors()).isEmpty()) {
                List cannotDecode = this.getConnectors(id, false);
                if (!cannotDecode.isEmpty()) {
                    ready.removeAll(cannotDecode);
                }
                if (!ready.isEmpty() && !this.exclusiveConnectors.isEmpty()) {
                    Iterator iter2 = ready.iterator();
                    while (iter2.hasNext()) {
                        CwsConnector cws2 = (CwsConnector)iter2.next();
                        if (!this.exclusiveConnectors.contains(cws2.getName())) continue;
                        iter2.remove();
                    }
                }
                canDecode = ready;
            }
            if (this.autoDiscoverAll && (unknown = this.getConnectorsUnknownChannelStatus(id)).isEmpty()) {
                unknown = null;
            }
        } else if (this.bcMissingSid) {
            this.logger.fine("Scheduling all connectors for probe broadcast. Sid: " + id);
            secondary = this.getReadyConnectors();
        }
        if (allowedConnectorNames != null) {
            if (!canDecode.isEmpty()) {
                iter = canDecode.iterator();
                while (iter.hasNext()) {
                    cws = (CwsConnector)iter.next();
                    if (allowedConnectorNames.contains(cws.getName())) continue;
                    iter.remove();
                }
            }
            if (secondary != null) {
                iter = secondary.iterator();
                while (iter.hasNext()) {
                    cws = (CwsConnector)iter.next();
                    if (allowedConnectorNames.contains(cws.getName())) continue;
                    iter.remove();
                }
            }
        }
        if (canDecode.size() > 1) {
            iter = new ArrayList(canDecode).iterator();
            while (iter.hasNext()) {
                boolean congested;
                cws = (CwsConnector)iter.next();
                if (cws.getTimeoutCount() > 0) {
                    this.logger.fine(cws + " in timeout-state (" + cws.getTimeoutCount() + "), excluding and sending keep-alive if needed.");
                    cws.sendKeepAlive();
                    if (canDecode.size() > 1) {
                        canDecode.remove(cws);
                    } else if (this.config.getConnManager().isHardLimit()) {
                        canDecode.remove(cws);
                        this.logger.warning("No candidates remain for service [" + serviceName + "] (timeouts or congestion), " + "returning empty");
                    }
                }
                int qTime = cws.getEstimatedQueueTime();
                int qSize = cws.getQueueSize();
                int utilization = cws.getUtilization(false);
                boolean bl = congested = qSize > 0 && (long)qTime > this.config.getConnManager().getCongestionLimit(this.profile) - (long)cws.getAverageEcmTime();
                if (utilization <= 100 && !congested) continue;
                if (canDecode.size() > 1) {
                    canDecode.remove(cws);
                    continue;
                }
                if (congested && this.config.getConnManager().isHardLimit()) {
                    canDecode.remove(cws);
                }
                String warn = cws + " congested and no alternatives exists for service [" + serviceName + "], queue " + "estimate is: " + qTime + " ms (" + qSize + " requests pending, " + utilization + "% utilization)" + (congested && this.config.getConnManager().isHardLimit() ? ", returning empty..." : "");
                if (this.config.isDebug()) {
                    this.logger.warning(warn);
                    continue;
                }
                this.logger.fine(warn);
            }
        }
        if (!serviceUnknown) {
            canDecode = this.selectByCwsMetric(canDecode);
        }
        if ((twoLeastLoaded = CwsServiceMapper.selectLeastLoaded(canDecode)) == null || twoLeastLoaded.length == 0) {
            leastLoaded = null;
        } else {
            leastLoaded = twoLeastLoaded[0];
            if (this.redundantForwarding && twoLeastLoaded.length > 1) {
                if (secondary == null) {
                    secondary = new ArrayList<CwsConnector>();
                }
                if (!secondary.contains(twoLeastLoaded[1])) {
                    secondary.add(twoLeastLoaded[1]);
                }
                secondary.remove(leastLoaded);
                if (secondary.isEmpty()) {
                    secondary = null;
                }
            }
        }
        if (unknown != null) {
            if (!serviceUnknown) {
                this.logger.fine("Unknown status for service [" + serviceName + "] on connectors: " + unknown);
            }
            if (leastLoaded == null) {
                leastLoaded = CwsServiceMapper.selectLeastLoaded(unknown)[0];
                unknown.remove(leastLoaded);
            } else {
                unknown.remove(leastLoaded);
            }
            if (unknown.isEmpty()) {
                unknown = null;
            }
        } else if (leastLoaded != null && !serviceUnknown && leastLoaded.getTimeoutCount() > 0) {
            this.logger.info(leastLoaded + " in timeout-state, but no alternatives exist for service [" + serviceName + "].");
        }
        if (secondary != null && leastLoaded != null) {
            secondary.remove(leastLoaded);
            if (secondary.isEmpty()) {
                secondary = null;
            }
        }
        return new ConnectorSelection(leastLoaded, secondary, unknown);
    }

    private List selectByCwsMetric(List l) {
        if (l == null || l.size() <= 1) {
            return l;
        }
        TreeMap cwsByMetric = new TreeMap();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            List<CwsConnector> tmp;
            CwsConnector cws = (CwsConnector)iter.next();
            Integer key = new Integer(cws.getMetric());
            if (cwsByMetric.containsKey(key)) {
                tmp = (List)cwsByMetric.get(key);
            } else {
                tmp = new ArrayList();
                cwsByMetric.put(key, tmp);
            }
            tmp.add(cws);
        }
        return (List)cwsByMetric.get(cwsByMetric.firstKey());
    }

    private static CwsConnector[] selectLeastLoaded(List l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        if (l.size() == 1) {
            return new CwsConnector[]{(CwsConnector)l.get(0)};
        }
        Collections.sort(l);
        return new CwsConnector[]{(CwsConnector)l.get(l.size() - 1), (CwsConnector)l.get(l.size() - 2)};
    }

    void setCanDecode(CamdNetMessage msg, CwsConnector conn, ProxySession session) {
        if (!this.enabled) {
            return;
        }
        ServiceMapping id = new ServiceMapping(msg);
        this.setLastFailed(id, conn.getName(), false, -1);
        this.failureCountMap.remove(id);
        List connectors = (ArrayList<String>)this.canDecodeMap.get(id);
        if (connectors == null) {
            connectors = new ArrayList<String>();
            this.canDecodeMap.put(id, connectors);
            if (id.getCustomId() != 0 && id.serviceId != 0 && !this.unknownServices.contains(new Integer(id.serviceId))) {
                this.canDecodeMap.put(new ServiceMapping(id.serviceId), connectors);
            }
        }
        if (!connectors.contains(conn.getName())) {
            connectors.add(conn.getName());
            String source = session == null ? msg.getOriginAddress() : session.toString();
            this.logger.info("Discovered service [" + this.config.getServiceName(msg) + "] on CWS: " + conn + (source == null ? "" : " - Ecm source was: " + source));
            if (session != null) {
                session.setFlag(msg, '+');
            }
            this.cacheUpdated = true;
            this.config.getConnManager().cwsFoundService(conn, this.config.getService(msg), !this.resetServices.contains(id) && !this.overrideCanDecodeMap.containsKey(id));
        }
        if ((connectors = (List)this.cannotDecodeMap.get(id)) != null && connectors.remove(conn.getName())) {
            this.cacheUpdated = true;
        }
    }

    void setCannotDecode(CamdNetMessage msg, CwsConnector conn, ProxySession session) {
        if (!this.enabled) {
            return;
        }
        if (this.exclusiveConnectors.contains(conn.getName())) {
            return;
        }
        ServiceMapping id = new ServiceMapping(msg);
        ArrayList<String> connectors = (ArrayList<String>)this.canDecodeMap.get(id);
        if (connectors != null && connectors.contains(conn.getName())) {
            if (this.isLastFailed(id, conn.getName(), session == null ? -1 : session.getId())) {
                connectors.remove(conn.getName());
                this.setLastFailed(id, conn.getName(), false, -1);
                if (session != null) {
                    String s = "Service [" + this.config.getServiceName(msg) + "] no longer available on CWS: " + conn.getName() + " - Ecm source was: " + session;
                    if (this.resetServices.contains(id)) {
                        this.logger.info(s);
                    } else {
                        this.logger.warning(s);
                    }
                }
                this.resetSingle(new ServiceMapping(id.serviceId, -1L), conn.getName());
                if (session != null) {
                    session.setFlag(msg, '-');
                }
                this.cacheUpdated = true;
                if (!this.isServiceOverridden(conn.getName(), id)) {
                    this.config.getConnManager().cwsLostService(conn, this.config.getService(msg), !this.resetServices.contains(id));
                }
                this.registerRediscovery(conn.getName(), id);
            } else {
                if (this.isServiceOverridden(conn.getName(), id)) {
                    if (session != null) {
                        this.logger.info("Service [" + this.config.getServiceName(msg) + "] failed to decode on CWS: " + conn.getName() + " (according to the manual can-decode list it should always decode). Ecm source was: " + session);
                    }
                    return;
                }
                if (session != null) {
                    String prevFlags = session instanceof CspSession ? null : session.getLastTransactionFlags();
                    String s = "Service [" + this.config.getServiceName(msg) + "] failed to decode on CWS: " + conn.getName() + " (two consecutive failures removes mapping). Ecm source was: " + session + (prevFlags == null ? "" : " [prev: " + prevFlags + "]");
                    if (this.resetServices.contains(id)) {
                        this.logger.info(s);
                    } else {
                        this.logger.warning(s);
                    }
                }
                this.setLastFailed(id, conn.getName(), true, session == null ? -1 : session.getId());
                return;
            }
        }
        if ((connectors = (List)this.cannotDecodeMap.get(id)) == null) {
            connectors = new ArrayList<String>();
            this.cannotDecodeMap.put(id, connectors);
        }
        if (!connectors.contains(conn.getName())) {
            connectors.add(conn.getName());
            this.logger.info("Service [" + this.config.getServiceName(msg) + "] cannot be decoded by CWS: " + conn.getName());
            this.cacheUpdated = true;
        }
    }

    void setMultiStatus(ServiceMapping[] sids, CwsConnector conn, boolean canDecode, boolean merge) {
        List<String> connectors;
        Map map;
        Map map2 = map = canDecode ? this.canDecodeMap : this.cannotDecodeMap;
        if (!merge) {
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                connectors = (ArrayList<String>)iter.next();
                if (connectors == null) continue;
                connectors.remove(conn.getName());
            }
        }
        for (int i = 0; i < sids.length; ++i) {
            connectors = (List)map.get(sids[i]);
            if (connectors == null) {
                connectors = new ArrayList<String>();
                map.put(sids[i], connectors);
            }
            if (connectors.contains(conn.getName())) continue;
            connectors.add(conn.getName());
        }
    }

    private void registerRediscovery(String cwsName, ServiceMapping id) {
        if (this.retryLostServices && id.getCustomData() != -1L) {
            this.rediscoverSet.add(new RediscoverTask(cwsName, id));
        }
    }

    private boolean isLastFailed(ServiceMapping id, String connectorName, int sessionId) {
        String key = connectorName + ":" + id;
        return this.failureMap.containsKey(key) && !new Integer(sessionId).equals(this.failureMap.get(key));
    }

    private void setLastFailed(ServiceMapping id, String connectorName, boolean failed, int sessionId) {
        String key = connectorName + ":" + id;
        if (failed) {
            this.failureMap.put(key, new Integer(sessionId));
        } else {
            this.failureMap.remove(key);
        }
    }

    Boolean canDecode(CwsConnector conn, ServiceMapping id) {
        if (this.isServiceUnknown(id.serviceId) && id.getCustomId() <= 0) {
            return null;
        }
        List canDecode = (ArrayList)this.canDecodeMap.get(id);
        canDecode = canDecode == null ? new ArrayList() : new ArrayList(canDecode);
        ArrayList cannotDecode = (ArrayList)this.cannotDecodeMap.get(id);
        cannotDecode = cannotDecode == null ? new ArrayList() : new ArrayList(cannotDecode);
        canDecode.addAll(this.getOverrideConnectors(id, true));
        cannotDecode.addAll(this.getOverrideConnectors(id, false));
        if (canDecode.contains(conn.getName())) {
            return Boolean.TRUE;
        }
        if (cannotDecode.contains(conn.getName())) {
            return Boolean.FALSE;
        }
        if (id.serviceId > 0 && !this.unknownServices.contains(new Integer(id.serviceId)) && (canDecode = (List)this.canDecodeMap.get(new ServiceMapping(id.serviceId))) != null && canDecode.contains(conn.getName())) {
            return Boolean.FALSE;
        }
        if (this.exclusiveConnectors.contains(conn.getName())) {
            return Boolean.FALSE;
        }
        return null;
    }

    private void incFailures(ServiceMapping id) {
        Integer count = (Integer)this.failureCountMap.get(id);
        count = count == null ? new Integer(1) : new Integer(count + 1);
        this.failureCountMap.put(id, count);
    }

    int getFailures(ServiceMapping id) {
        Integer count = (Integer)this.failureCountMap.get(id);
        if (count == null) {
            return 0;
        }
        return count;
    }

    void resetListedServices() {
        if (!this.enabled) {
            return;
        }
        if (!this.resetServices.isEmpty()) {
            this.logger.info("Resetting services: " + CwsServiceMapper.getHexStr(this.resetServices));
            Iterator iter = this.resetServices.iterator();
            while (iter.hasNext()) {
                this.resetStatus((ServiceMapping)iter.next());
            }
        }
    }

    private static String getHexStr(Collection c) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(" ");
        }
        return sb.toString().trim();
    }

    boolean resetStatus(ServiceMapping id) {
        boolean removed;
        boolean bl = removed = this.canDecodeMap.remove(id) != null;
        if (this.cannotDecodeMap.remove(id) != null) {
            removed = true;
        }
        if (removed) {
            if (id.getCustomId() > 0) {
                this.canDecodeMap.remove(new ServiceMapping(id.serviceId));
            }
            this.logger.info("Status reset for service [" + this.config.getServiceName(this.profile.getName(), id.serviceId) + "]");
            this.failureCountMap.remove(id);
            return true;
        }
        return false;
    }

    int resetStatus(String cwsName, boolean full) {
        List connectors;
        int count = 0;
        Iterator iter = new ArrayList(this.cannotDecodeMap.values()).iterator();
        while (iter.hasNext()) {
            connectors = (List)iter.next();
            if (!connectors.remove(cwsName)) continue;
            ++count;
        }
        if (full) {
            iter = new ArrayList(this.canDecodeMap.values()).iterator();
            while (iter.hasNext()) {
                connectors = (List)iter.next();
                if (!connectors.remove(cwsName)) continue;
                ++count;
            }
        }
        this.logger.info("Status reset for CWS[" + cwsName + "], " + count + " service entries cleared.");
        this.failureCountMap.clear();
        return count;
    }

    boolean resetSingle(ServiceMapping id, String cwsName) {
        List cannotDecode = (List)this.cannotDecodeMap.get(id);
        if (cannotDecode != null && cannotDecode.remove(cwsName)) {
            if (id.getCustomData() != -1L) {
                this.logger.info("Status reset for service [" + this.config.getServiceName(this.profile.getName(), id.serviceId) + "] on CWS[" + cwsName + "]");
            }
            if (id.getCustomId() > 0) {
                this.resetSingle(new ServiceMapping(id.serviceId), cwsName);
            }
            return true;
        }
        return false;
    }

    void addConnector(CwsConnector cws) {
        if (cws.getProfile().getCaId() != this.profile.getCaId()) {
            throw new IllegalStateException("Connector CaID doesn't match Mapper!");
        }
        if (!this.connectors.containsKey(cws.getName())) {
            this.connectors.put(cws.getName(), cws);
        }
    }

    void removeConnector(CwsConnector cws) {
        this.connectors.remove(cws.getName());
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void blockService(int sid) {
        ServiceMapping sm = new ServiceMapping(sid, 0L);
        sm.setProviderIdent(0xFFFFFF);
        this.blockedServices.add(sm);
        this.logger.fine("Blocked services: " + this.blockedServices);
        this.blockedSrvStr = this.serviceTokensToStr(this.blockedServices);
    }

    public void unblockService(int sid) {
        ServiceMapping sm = new ServiceMapping(sid, 0L);
        sm.setProviderIdent(0xFFFFFF);
        this.blockedServices.remove(sm);
        this.logger.fine("Blocked services: " + this.blockedServices);
        this.blockedSrvStr = this.blockedServices.isEmpty() ? null : this.serviceTokensToStr(this.blockedServices);
    }

    public void resetLostStatus() {
        if (!this.enabled || !this.retryLostServices) {
            this.rediscoverSet.clear();
            return;
        }
        Iterator iter = new ArrayList(this.rediscoverSet).iterator();
        while (iter.hasNext()) {
            RediscoverTask task = (RediscoverTask)iter.next();
            List canDecode = (List)this.canDecodeMap.get(task.getId());
            if (canDecode != null && canDecode.contains(task.getCwsName())) {
                this.rediscoverSet.remove(task);
                continue;
            }
            if (!task.isDue()) continue;
            this.resetSingle(task.getId(), task.getCwsName());
            if (!task.setChecked()) continue;
            this.rediscoverSet.remove(task);
        }
    }

    static class RediscoverTask
    implements Serializable {
        static final long MAX_INTERVAL = 172800000L;
        private String cwsName;
        private ServiceMapping id;
        private long checkInterval;
        private long nextCheck;

        public RediscoverTask(String cwsName, ServiceMapping id) {
            this.cwsName = cwsName;
            this.id = id;
            this.checkInterval = 300000L;
            this.setChecked();
        }

        public boolean setChecked() {
            this.nextCheck = System.currentTimeMillis() + this.checkInterval;
            this.checkInterval *= 2L;
            return this.checkInterval > 172800000L;
        }

        public boolean isDue() {
            return System.currentTimeMillis() > this.nextCheck;
        }

        public String getCwsName() {
            return this.cwsName;
        }

        public ServiceMapping getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RediscoverTask that = (RediscoverTask)o;
            if (!this.cwsName.equals(that.cwsName)) {
                return false;
            }
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int result = this.cwsName.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public String toString() {
            return "[" + this.cwsName + ":" + this.id + "] due: " + new Date(this.nextCheck) + " | interval: " + this.checkInterval / 1000L / 60L;
        }
    }
}

