/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.SimpleUserManager;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.FileFetcher;
import com.bowman.xml.XMLConfig;
import com.bowman.xml.XMLConfigException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XmlUserManager
extends SimpleUserManager
implements Runnable {
    private ProxyLogger logger;
    protected Thread fetchThread;
    protected Thread updateThread;
    protected Map sources = new HashMap();
    protected Map lastParsed = new HashMap();
    protected long updateInterval;

    public XmlUserManager() {
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        super.configUpdated(xml);
        this.sources.clear();
        Iterator iter = xml.getMultipleSubConfigs("user-source");
        if (iter != null) {
            while (iter.hasNext()) {
                this.addSource((ProxyXmlConfig)iter.next(), null);
            }
        }
        if (this.sources.isEmpty()) {
            this.addSource(xml, "default");
        }
        this.updateInterval = xml.getTimeValue("update-interval", 0, "m");
        if (this.updateInterval > 0L) {
            if (this.updateThread == null) {
                this.updateThread = new Thread((Runnable)this, "XmlUserManagerUpdateThread");
                this.updateThread.start();
            }
        } else if (this.updateThread != null) {
            this.updateThread.interrupt();
            this.updateThread = null;
        }
        this.pollUserSources();
        this.registerCtrlCommands();
    }

    protected void addSource(ProxyXmlConfig xml, String name) throws ConfigException {
        if (name == null) {
            name = xml.getStringValue("name");
        }
        XmlUserSource source = new XmlUserSource(name);
        String url = xml.getStringValue("user-file-url");
        try {
            source.fileUri = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(xml.getFullName(), "user-file-url", "Malformed URL: " + e.getMessage());
        }
        try {
            source.key = xml.getStringValue("user-file-key");
        }
        catch (ConfigException e) {
            source.key = null;
        }
        source.lastModified = -1L;
        this.sources.put(source.name, source);
        UserData last = (UserData)this.lastParsed.get(source.name);
        if (last != null) {
            this.users.putAll(last.users);
        }
    }

    protected void registerCtrlCommands() {
        try {
            new CtrlCommand("update-users", "Run update", "Fetch/install user files now.").register(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public CtrlCommandResult runCtrlCmdUpdateUsers() {
        this.pollUserSources();
        return new CtrlCommandResult(true, "Updated performed.");
    }

    public boolean isEnabled(String user) {
        if (this.matchesOpen(user)) {
            return true;
        }
        SimpleUserManager.UserEntry entry = this.getUser(user);
        if (entry == null) {
            return false;
        }
        return entry.enabled;
    }

    protected void pollUserSources() {
        Iterator iter = this.sources.values().iterator();
        while (iter.hasNext()) {
            XmlUserSource source = (XmlUserSource)iter.next();
            UserData last = (UserData)this.lastParsed.get(source.name);
            try {
                this.logger.fine("[" + source.name + "] Fetching '" + source.fileUri + (source.lastModified != -1L ? ", lm: " + new Date(source.lastModified) : ""));
                String newFile = FileFetcher.fetchFile(source.fileUri, source.key, source.lastModified);
                if (newFile != null) {
                    if (last != null && last.userFile.hashCode() == newFile.hashCode()) {
                        this.logger.fine("[" + source.name + "] No changes found after fetch...");
                        continue;
                    }
                    if (!this.processUserFile(source, newFile)) continue;
                    last = (UserData)this.lastParsed.get(source.name);
                    this.logger.fine("[" + source.name + "] Parsed " + last.users.size() + " users from '" + source.fileUri + "'");
                    continue;
                }
                this.logger.fine("[" + source.name + "] User file unchanged...");
            }
            catch (IOException e) {
                this.logger.throwing(e);
                this.logger.warning("Failed to fetch user file '" + source.fileUri + "': " + e);
            }
        }
    }

    protected boolean processUserFile(XmlUserSource source, String newFile) {
        try {
            ProxyXmlConfig xml = new ProxyXmlConfig(new XMLConfig(newFile, false));
            HashMap newUsers = new HashMap();
            Iterator iter = xml.getMultipleSubConfigs("user");
            while (iter.hasNext()) {
                this.addUser(this.parseUser((ProxyXmlConfig)iter.next()), newUsers, true);
            }
            this.users.putAll(newUsers);
            UserData last = (UserData)this.lastParsed.get(source.name);
            if (last != null) {
                last.users.keySet().removeAll(newUsers.keySet());
                if (!last.users.keySet().isEmpty()) {
                    this.logger.fine("[" + source.name + "] Removing " + last.users.keySet().size() + " deleted users.");
                    Iterator iter2 = last.users.keySet().iterator();
                    while (iter2.hasNext()) {
                        this.users.remove(iter2.next());
                    }
                }
            }
            this.lastParsed.put(source.name, new UserData(newUsers, newFile));
            source.lastModified = System.currentTimeMillis();
            return true;
        }
        catch (XMLConfigException e) {
            this.logger.throwing(e);
            this.logger.warning("Unable to parse '" + source.fileUri + "': " + e.getMessage());
        }
        catch (ConfigException e) {
            this.logger.throwing(e);
            this.logger.warning("Error in user file '" + source.fileUri + "': " + e.getMessage());
        }
        return false;
    }

    public void run() {
        if (Thread.currentThread() == this.updateThread) {
            while (this.updateThread != null) {
                try {
                    Thread.sleep(this.updateInterval);
                    this.fetchThread = new Thread((Runnable)this, "XmlUserManagerFetchThread");
                    this.fetchThread.start();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        } else if (Thread.currentThread() == this.fetchThread) {
            this.pollUserSources();
        }
    }

    static class UserData {
        Map users;
        String userFile;

        UserData(Map users, String userFile) {
            this.users = users;
            this.userFile = userFile;
        }
    }

    static class XmlUserSource {
        URL fileUri;
        String name;
        String userFile;
        String key;
        long lastModified;

        XmlUserSource(String name) {
            this.name = name;
        }
    }
}

